<?php

class Application_Model_BlogLogic extends Application_Model_Blog
{
    public function fetchDataTableSelect()
    {
        $columns = array('blog_title', 'blog_short_desc', 'blog_url', 'blog_status', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_BlogLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('blog_status != ?', 'D');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Blog:Edit")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"blog", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Blog:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"blog", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->blog_title, $row->blog_short_desc, $row->blog_url, ($row->blog_status == 'A') ? 'Active' : ($row->blog_status == 'E') ? 'Draft' : 'Block', $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getActiveBlogs($limit = 0) {
        $where = $this->select()->where('blog_status = ?', 'A')->order('id desc');
        if($limit > 0) {
            $where->limit($limit);
        }
        return $this->fetchAll($where);
    }
    
    public function countBlogUrl($url) {
        $where = $this->select()->where('blog_status = ?', 'A')->where('blog_url = ?', $url);
        return count($this->fetchAll($where));
    }
    
    public function generateBlogUrl($url) {
        $url = strtolower(preg_replace('/[^a-zA-Z0-9]/', '-', $url));
        $existRecord = $this->countBlogUrl($url);
        if($existRecord > 0) {
            return $url.'-'.$existRecord;
        }else {
            return $url;
        }
    }
    
    public function getActiveBlogCategory() {
        $sql = "select category_title as category, count(*) as total from asit_blog b left join asit_category c on (b.blog_category = c.id) where blog_status = 'A' group by blog_category";
        return $this->getAdapter()->fetchAll($sql);
    }
    
    public function getActiveBlogsSelect($catId = 0) {
        $where = $this->select()->where('blog_status = ?', 'A')->order('id desc');
        if($catId > 0) {
            $where->where('blog_category = ?', $catId);
        }
        return $where;
    }
    
    public function getActiveArchiveBlogSelect($month) {
        $date = explode('-', $month);
        $where = $this->select()->where('blog_status = ?', 'A')->where('MONTH(blog_created_date) = ?', $date[0])->where('YEAR(blog_created_date) = ?', $date[1])->order('id desc');
        return $where;
    }
    
    public function searchActiveBlogSelect($query) {
        $where = $this->select()->where('blog_status = ?', 'A')->order('id desc');
        $select = $this->select();
        foreach(explode(' ', $query) as $q) {
            $select->orWhere('LOWER(blog_title) like ?', '%'.strtolower($q).'%')->orWhere('LOWER(blog_short_desc) like ?', '%'.strtolower($q).'%')->orWhere('LOWER(blog_desc) like ?', '%'.strtolower($q).'%')->orWhere('LOWER(blog_meta_key) like ?', '%'.strtolower($q).'%')->orWhere('LOWER(blog_meta_desc) like ?', '%'.strtolower($q).'%');
        }
        $where->where(implode(' ', $select->getPart(Zend_Db_Select::WHERE)));
        return $where;
    }
    
    public function getDistinctBlogMonthYear() {
        $sql = "SELECT DATE_FORMAT(blog_created_date,'%m-%Y') as id, DATE_FORMAT(blog_created_date,'%M %Y') as month, count(*) as total FROM `asit_blog` where blog_status = 'A' GROUP BY DATE_FORMAT(blog_created_date,'%M %Y') order by blog_created_date desc";
        return $this->getAdapter()->fetchAll($sql);
    }
    
    public function getBlogIdByUrl($url) {
        $where = $this->select()->where('blog_url = ?', $url)->where('blog_status = ?', 'A');
        $row = $this->fetchRow($where);
        return $row['id'];
    }
    
}

