<?php

class Application_Model_Cache_Config extends Application_Model_Cache_Util
{
    
    const CACHE_DIR = '../cache';
    //const CACHE_DIR = '/var/lib/openshift/568eaacf0c1e667ffd000010/app-root/data/cache';
    
    public function generateCache()
    {
        $cache = $this->getDBObject(self::CACHE_DIR);
        $id = 'config';
        if(($result = $cache->load($id)) === false) {
            $obj_config = new Application_Model_ConfigLogic(-1);
            $results = $obj_config->getConfigElementsForCache();
            $cache->save($results, $id);
        }
    }
    
    public static function getConfig($key)
    {
        $obj_cache = new Application_Model_Cache_Config(); 
        $cache = $obj_cache->getDBObject(self::CACHE_DIR);
        if(($result = $cache->load('config')) === false) {
            $obj_cache->generateCache();
        }else {
            return $result[$key];
        }
    }
    
    public function resetConfigCache()
    {
        $cache = $this->getDBObject(self::getConfig('CACHE_DIR'), 0);
        $cache->remove('config');
    }
    
}

