<?php

class Application_Model_Cache_Loader
{
    
    public function __construct() {
        
        $this->generateConfigCache();
        $this->generateRoleCache();
        //$this->createUploadsDirectory();
    }
    
    public function generateRoleCache() {
        $this->createDirectory(Application_Model_Cache_Config::CACHE_DIR.'/role');
        $obj_role = new Application_Model_RoleLogic(-1);
        foreach ($obj_role->fetchAll() as $role) {
            $cache_role = new Application_Model_Cache_Role();
            $cache_role->resetRoleCache($role->id);
            $cache_role->roleCache($role->id);
        }
    }
    
    public function generateConfigCache() {
        $this->createDirectory(Application_Model_Cache_Config::CACHE_DIR.'/config');
        $cache_config = new Application_Model_Cache_Config();
        //$cache_config->resetConfigCache();
        $cache_config->generateCache();
    }
    
}
