<?php

class Application_Model_Cache_Map extends Application_Model_Cache_Util
{
    
    public function getCache($id)
    {
        $id = (String) $id;
        $cache = $this->getDBObject(Application_Model_Cache_Config::getConfig('CACHE_DIR').'/map/');
        if(($result = $cache->load($id)) === false) {
            return null;
        }else {
            return $result;
        }
    }
    
    public function generateCache($id, $results)
    {
        $id = (String) $id;
        $cache = $this->getDBObject(Application_Model_Cache_Config::getConfig('CACHE_DIR').'/map/');
        if(($result = $cache->load($id)) === false) {
            $cache->save($results, $id);
        }
        return $result;
    }
    
    public function resetCache($id)
    {
        $cache = $this->getDBObject(Application_Model_Cache_Config::getConfig('CACHE_DIR').'/map/', 0);
        $cache->remove($id);
    }
    
}

