<?php

class Application_Model_Cache_Util
{
    
    public function getDBObject($dir = '../cache/', $lifetime = 31536000)
    {
        return $this->getCacheObject($dir, $lifetime);
    }
    
    public function getPageObject($dir = '../cache/', $lifetime = 31536000)
    {
        return $this->getCacheObject($dir, $lifetime, false, 'Output');
    }
    
    private function getCacheObject($dir = '../cache/', $lifetime = 31536000, $serialization = true, $type = 'Core') //set $type as Output and serialization as false for caching the page content.
    {
        $baseUrl = new Zend_View_Helper_BaseUrl();
        $cachedir = $dir;//$baseUrl->baseUrl($dir);
        $frontend = array( 'lifetime' => $lifetime, 'automatic_serialization' => $serialization );
        if(!is_dir($cachedir)){ mkdir($cachedir,0755); }
        $backend = array('cache_dir' => $cachedir);
        $cache = Zend_Cache::factory($type, 'File', $frontend, $backend);
        return $cache;
    }
    
    
}