<?php

class Application_Model_Category extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_category';

    private $_id = null;

    private $_category_icon = null;

    private $_category_title = null;

    private $_category_desc = null;

    private $_category_meta_key = null;

    private $_category_parent = null;

    private $_category_type = null;

    private $_category_image = null;

    private $_category_listings = null;

    private $_category_status = null;

    private $_category_updated_by = null;

    private $_category_updated_date = null;

    private $_category_created_by = null;

    private $_category_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get category_icon method is stand for get the value of category_icon.
     *
     * @var varchar category_icon
     */
    public function get_category_icon()
    {
        return $this->_category_icon;
    }

    /**
     * set category_icon method is stand for set the value of category_icon.
     *
     * @var varchar category_icon
     */
    public function set_category_icon($value)
    {
        $this->_category_icon = $value;
    }

    /**
     * get category_title method is stand for get the value of category_title.
     *
     * @var varchar category_title
     */
    public function get_category_title()
    {
        return $this->_category_title;
    }

    /**
     * set category_title method is stand for set the value of category_title.
     *
     * @var varchar category_title
     */
    public function set_category_title($value)
    {
        $this->_category_title = $value;
    }

    /**
     * get category_desc method is stand for get the value of category_desc.
     *
     * @var varchar category_desc
     */
    public function get_category_desc()
    {
        return $this->_category_desc;
    }

    /**
     * set category_desc method is stand for set the value of category_desc.
     *
     * @var varchar category_desc
     */
    public function set_category_desc($value)
    {
        $this->_category_desc = $value;
    }

    /**
     * get category_meta_key method is stand for get the value of category_meta_key.
     *
     * @var varchar category_meta_key
     */
    public function get_category_meta_key()
    {
        return $this->_category_meta_key;
    }

    /**
     * set category_meta_key method is stand for set the value of category_meta_key.
     *
     * @var varchar category_meta_key
     */
    public function set_category_meta_key($value)
    {
        $this->_category_meta_key = $value;
    }

    /**
     * get category_parent method is stand for get the value of category_parent.
     *
     * @var int category_parent
     */
    public function get_category_parent()
    {
        return (int) $this->_category_parent;
    }

    /**
     * set category_parent method is stand for set the value of category_parent.
     *
     * @var int category_parent
     */
    public function set_category_parent($value)
    {
        $this->_category_parent = (int) $value;
    }

    /**
     * get category_type method is stand for get the value of category_type.
     *
     * @var varchar category_type
     */
    public function get_category_type()
    {
        return $this->_category_type;
    }

    /**
     * set category_type method is stand for set the value of category_type.
     *
     * @var varchar category_type
     */
    public function set_category_type($value)
    {
        $this->_category_type = $value;
    }

    /**
     * get category_image method is stand for get the value of category_image.
     *
     * @var varchar category_image
     */
    public function get_category_image()
    {
        return $this->_category_image;
    }

    /**
     * set category_image method is stand for set the value of category_image.
     *
     * @var varchar category_image
     */
    public function set_category_image($value)
    {
        $this->_category_image = $value;
    }

    /**
     * get category_listings method is stand for get the value of category_listings.
     *
     * @var int category_listings
     */
    public function get_category_listings()
    {
        return (int) $this->_category_listings;
    }

    /**
     * set category_listings method is stand for set the value of category_listings.
     *
     * @var int category_listings
     */
    public function set_category_listings($value)
    {
        $this->_category_listings = (int) $value;
    }

    /**
     * get category_status method is stand for get the value of category_status.
     *
     * @var varchar category_status
     */
    public function get_category_status()
    {
        return $this->_category_status;
    }

    /**
     * set category_status method is stand for set the value of category_status.
     *
     * @var varchar category_status
     */
    public function set_category_status($value)
    {
        $this->_category_status = $value;
    }

    /**
     * get category_updated_by method is stand for get the value of
     * category_updated_by.
     *
     * @var int category_updated_by
     */
    public function get_category_updated_by()
    {
        return (int) $this->_category_updated_by;
    }

    /**
     * set category_updated_by method is stand for set the value of
     * category_updated_by.
     *
     * @var int category_updated_by
     */
    public function set_category_updated_by($value)
    {
        $this->_category_updated_by = (int) $value;
    }

    /**
     * get category_updated_date method is stand for get the value of
     * category_updated_date.
     *
     * @var timestamp category_updated_date
     */
    public function get_category_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_category_updated_date));
    }

    /**
     * set category_updated_date method is stand for set the value of
     * category_updated_date.
     *
     * @var timestamp category_updated_date
     */
    public function set_category_updated_date($value)
    {
        $this->_category_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get category_created_by method is stand for get the value of
     * category_created_by.
     *
     * @var int category_created_by
     */
    public function get_category_created_by()
    {
        return (int) $this->_category_created_by;
    }

    /**
     * set category_created_by method is stand for set the value of
     * category_created_by.
     *
     * @var int category_created_by
     */
    public function set_category_created_by($value)
    {
        $this->_category_created_by = (int) $value;
    }

    /**
     * get category_created_date method is stand for get the value of
     * category_created_date.
     *
     * @var timestamp category_created_date
     */
    public function get_category_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_category_created_date));
    }

    /**
     * set category_created_date method is stand for set the value of
     * category_created_date.
     *
     * @var timestamp category_created_date
     */
    public function set_category_created_date($value)
    {
        $this->_category_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_category by set id thru constructor.
     *
     * @var int id
     * @var varchar category_icon
     * @var varchar category_title
     * @var varchar category_desc
     * @var varchar category_meta_key
     * @var int category_parent
     * @var varchar category_type
     * @var varchar category_image
     * @var int category_listings
     * @var varchar category_status
     * @var int category_updated_by
     * @var timestamp category_updated_date
     * @var int category_created_by
     * @var timestamp category_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_category_icon($row->category_icon);
          $this->set_category_title($row->category_title);
          $this->set_category_desc($row->category_desc);
          $this->set_category_meta_key($row->category_meta_key);
          $this->set_category_parent($row->category_parent);
          $this->set_category_type($row->category_type);
          $this->set_category_image($row->category_image);
          $this->set_category_listings($row->category_listings);
          $this->set_category_status($row->category_status);
          $this->set_category_updated_by($row->category_updated_by);
          $this->set_category_updated_date($row->category_updated_date);
          $this->set_category_created_by($row->category_created_by);
          $this->set_category_created_date($row->category_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar category_icon
     * @var varchar category_title
     * @var varchar category_desc
     * @var varchar category_meta_key
     * @var int category_parent
     * @var varchar category_type
     * @var varchar category_image
     * @var int category_listings
     * @var varchar category_status
     * @var int category_updated_by
     * @var int category_created_by
     */
    public function save()
    {
        $data = array(
          "category_icon" => $this->get_category_icon(),
          "category_title" => $this->get_category_title(),
          "category_desc" => $this->get_category_desc(),
          "category_meta_key" => $this->get_category_meta_key(),
          "category_parent" => $this->get_category_parent(),
          "category_type" => $this->get_category_type(),
          "category_image" => $this->get_category_image(),
          "category_listings" => $this->get_category_listings(),
          "category_status" => $this->get_category_status(),
          "category_updated_by" => $this->get_category_updated_by(),
          "category_created_by" => $this->get_category_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_category by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_category_icon_by_id method is stand for get the value ofcategory_icon By id.
     *
     * @var varchar category_icon
     */
    public function get_category_icon_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_category_icon();
    }

    /**
     * get_category_title_by_id method is stand for get the value ofcategory_title By
     * id.
     *
     * @var varchar category_title
     */
    public function get_category_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_category_title();
    }

    /**
     * get_category_desc_by_id method is stand for get the value ofcategory_desc By id.
     *
     * @var varchar category_desc
     */
    public function get_category_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_category_desc();
    }

    /**
     * get_category_meta_key_by_id method is stand for get the value
     * ofcategory_meta_key By id.
     *
     * @var varchar category_meta_key
     */
    public function get_category_meta_key_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_category_meta_key();
    }

    /**
     * get_category_parent_by_id method is stand for get the value ofcategory_parent By
     * id.
     *
     * @var int category_parent
     */
    public function get_category_parent_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_category_parent();
    }

    /**
     * get_category_type_by_id method is stand for get the value ofcategory_type By id.
     *
     * @var varchar category_type
     */
    public function get_category_type_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_category_type();
    }

    /**
     * get_category_image_by_id method is stand for get the value ofcategory_image By
     * id.
     *
     * @var varchar category_image
     */
    public function get_category_image_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_category_image();
    }

    /**
     * get_category_listings_by_id method is stand for get the value
     * ofcategory_listings By id.
     *
     * @var int category_listings
     */
    public function get_category_listings_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_category_listings();
    }

    /**
     * get_category_status_by_id method is stand for get the value ofcategory_status By
     * id.
     *
     * @var varchar category_status
     */
    public function get_category_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_category_status();
    }

    /**
     * get_category_updated_by_by_id method is stand for get the value
     * ofcategory_updated_by By id.
     *
     * @var int category_updated_by
     */
    public function get_category_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_category_updated_by();
    }

    /**
     * get_category_updated_date_by_id method is stand for get the value
     * ofcategory_updated_date By id.
     *
     * @var timestamp category_updated_date
     */
    public function get_category_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_category_updated_date()));
    }

    /**
     * get_category_created_by_by_id method is stand for get the value
     * ofcategory_created_by By id.
     *
     * @var int category_created_by
     */
    public function get_category_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_category_created_by();
    }

    /**
     * get_category_created_date_by_id method is stand for get the value
     * ofcategory_created_date By id.
     *
     * @var timestamp category_created_date
     */
    public function get_category_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_category_created_date()));
    }


}
