<?php

class Application_Model_CategoryLogic extends Application_Model_Category
{
    const CATEGORY_TYPE_NORMAL = 'N';
    const CATEGORY_TYPE_FEATURE = 'F';
    const CATEGORY_TYPE_BLOG = 'B';
    
    public static $categoryType = array(self::CATEGORY_TYPE_NORMAL=>"Normal", self::CATEGORY_TYPE_FEATURE=>"Featured", self::CATEGORY_TYPE_BLOG=>"Blog");
    
    public function fetchDataTableSelect() 
    {
        $user = new Application_Model_UserLogic(-1);
        $columns = array('c.category_title', 'c.category_desc', 'p.category_title', 'c.category_status');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_CategoryLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->from(array("c"=>$this->_name, "p"=>$this->_name), 
                array("c.id", "c.category_title", 'c.category_desc', 'p.category_title as parent_category', 'c.category_status'));
        $where->joinLeft(array("p"=>$this->_name),
                'c.category_parent = p.id', array())
                ->setIntegrityCheck(false);
        $where->where('c.category_status != ?', 'D');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $baseUrl = new Zend_View_Helper_BaseUrl();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Category:Edit")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"category", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Category:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"category", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $status = Application_Model_Cache_Config::getConfig('STATUS_TYPE');
            $results[$i] = array($row->category_title, $row->category_desc, ($row->parent_category == '') ? '<b>Parent Category</b>' : $row->parent_category, $status[$row->category_status], $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getParentCategory() {
        $where = $this->select()->where('category_parent = ?', 0)->where('category_status = ?', 'A')->where('category_type != ?', 'B');
        return $this->fetchAll($where);
    }
    
    public function getBlogParentCategory() {
        $where = $this->select()->where('category_parent = ?', 0)->where('category_status = ?', 'A');
        return $this->fetchAll($where);
    }

    public function getSubCategory($id) {
        $where = $this->select()->where('category_parent = ?', $id)->where('category_status = ?', 'A');
        return $this->fetchAll($where);
    }
    
    public function getCategoryByType($type) {
        $where = $this->select()->where('category_type = ?', $type)->where('category_status = ?', 'A');
        return $this->fetchAll($where);
    }
    
    public function getIdByTitle($catTitle)
    {
        $select = $this->select()->where('lower(replace(category_title, \' \', \'-\'))=?', $catTitle);
        $row = $this->fetchRow($select);
        $id = ($row!=null) ? (int)$row->id : -1;
        return $id;
    }
}

