<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Activity
 *
 * @author Akhil Kumar
 */
class Application_Model_Circular extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_circular';

    private $_id = null;

    private $_circular_title = null;

    private $_circular_desc = null;

    private $_circular_file = null;

    private $_circular_status = null;

    private $_circular_updated_by = null;

    private $_circular_updated_date = null;

    private $_circular_created_by = null;

    private $_circular_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get circular_title method is stand for get the value of circular_title.
     *
     * @var varchar circular_title
     */
    public function get_circular_title()
    {
        return $this->_circular_title;
    }

    /**
     * set circular_title method is stand for set the value of circular_title.
     *
     * @var varchar circular_title
     */
    public function set_circular_title($value)
    {
        $this->_circular_title = $value;
    }

    /**
     * get circular_desc method is stand for get the value of circular_desc.
     *
     * @var varchar circular_desc
     */
    public function get_circular_desc()
    {
        return $this->_circular_desc;
    }

    /**
     * set circular_desc method is stand for set the value of circular_desc.
     *
     * @var varchar circular_desc
     */
    public function set_circular_desc($value)
    {
        $this->_circular_desc = $value;
    }

    /**
     * get circular_file method is stand for get the value of circular_file.
     *
     * @var varchar circular_file
     */
    public function get_circular_file()
    {
        return $this->_circular_file;
    }

    /**
     * set circular_file method is stand for set the value of circular_file.
     *
     * @var varchar circular_file
     */
    public function set_circular_file($value)
    {
        $this->_circular_file = $value;
    }

    /**
     * get circular_status method is stand for get the value of circular_status.
     *
     * @var varchar circular_status
     */
    public function get_circular_status()
    {
        return $this->_circular_status;
    }

    /**
     * set circular_status method is stand for set the value of circular_status.
     *
     * @var varchar circular_status
     */
    public function set_circular_status($value)
    {
        $this->_circular_status = $value;
    }

    /**
     * get circular_updated_by method is stand for get the value of
     * circular_updated_by.
     *
     * @var int circular_updated_by
     */
    public function get_circular_updated_by()
    {
        return (int) $this->_circular_updated_by;
    }

    /**
     * set circular_updated_by method is stand for set the value of
     * circular_updated_by.
     *
     * @var int circular_updated_by
     */
    public function set_circular_updated_by($value)
    {
        $this->_circular_updated_by = (int) $value;
    }

    /**
     * get circular_updated_date method is stand for get the value of
     * circular_updated_date.
     *
     * @var timestamp circular_updated_date
     */
    public function get_circular_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_circular_updated_date));
    }

    /**
     * set circular_updated_date method is stand for set the value of
     * circular_updated_date.
     *
     * @var timestamp circular_updated_date
     */
    public function set_circular_updated_date($value)
    {
        $this->_circular_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get circular_created_by method is stand for get the value of
     * circular_created_by.
     *
     * @var int circular_created_by
     */
    public function get_circular_created_by()
    {
        return (int) $this->_circular_created_by;
    }

    /**
     * set circular_created_by method is stand for set the value of
     * circular_created_by.
     *
     * @var int circular_created_by
     */
    public function set_circular_created_by($value)
    {
        $this->_circular_created_by = (int) $value;
    }

    /**
     * get circular_created_date method is stand for get the value of
     * circular_created_date.
     *
     * @var timestamp circular_created_date
     */
    public function get_circular_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_circular_created_date));
    }

    /**
     * set circular_created_date method is stand for set the value of
     * circular_created_date.
     *
     * @var timestamp circular_created_date
     */
    public function set_circular_created_date($value)
    {
        $this->_circular_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_circular by set id thru constructor.
     *
     * @var int id
     * @var varchar circular_title
     * @var varchar circular_desc
     * @var varchar circular_file
     * @var varchar circular_status
     * @var int circular_updated_by
     * @var timestamp circular_updated_date
     * @var int circular_created_by
     * @var timestamp circular_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_circular_title($row->circular_title);
          $this->set_circular_desc($row->circular_desc);
          $this->set_circular_file($row->circular_file);
          $this->set_circular_status($row->circular_status);
          $this->set_circular_updated_by($row->circular_updated_by);
          $this->set_circular_updated_date($row->circular_updated_date);
          $this->set_circular_created_by($row->circular_created_by);
          $this->set_circular_created_date($row->circular_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar circular_title
     * @var varchar circular_desc
     * @var varchar circular_file
     * @var varchar circular_status
     * @var int circular_updated_by
     * @var int circular_created_by
     */
    public function save()
    {
        $data = array(
          "circular_title" => $this->get_circular_title(),
          "circular_desc" => $this->get_circular_desc(),
          "circular_file" => $this->get_circular_file(),
          "circular_status" => $this->get_circular_status(),
          "circular_updated_by" => $this->get_circular_updated_by(),
          "circular_created_by" => $this->get_circular_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_circular by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_circular_title_by_id method is stand for get the value ofcircular_title By
     * id.
     *
     * @var varchar circular_title
     */
    public function get_circular_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_circular_title();
    }

    /**
     * get_circular_desc_by_id method is stand for get the value ofcircular_desc By id.
     *
     * @var varchar circular_desc
     */
    public function get_circular_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_circular_desc();
    }

    /**
     * get_circular_file_by_id method is stand for get the value ofcircular_file By id.
     *
     * @var varchar circular_file
     */
    public function get_circular_file_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_circular_file();
    }

    /**
     * get_circular_status_by_id method is stand for get the value ofcircular_status By
     * id.
     *
     * @var varchar circular_status
     */
    public function get_circular_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_circular_status();
    }

    /**
     * get_circular_updated_by_by_id method is stand for get the value
     * ofcircular_updated_by By id.
     *
     * @var int circular_updated_by
     */
    public function get_circular_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_circular_updated_by();
    }

    /**
     * get_circular_updated_date_by_id method is stand for get the value
     * ofcircular_updated_date By id.
     *
     * @var timestamp circular_updated_date
     */
    public function get_circular_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_circular_updated_date()));
    }

    /**
     * get_circular_created_by_by_id method is stand for get the value
     * ofcircular_created_by By id.
     *
     * @var int circular_created_by
     */
    public function get_circular_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_circular_created_by();
    }

    /**
     * get_circular_created_date_by_id method is stand for get the value
     * ofcircular_created_date By id.
     *
     * @var timestamp circular_created_date
     */
    public function get_circular_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_circular_created_date()));
    }


}
