<?php

class Application_Model_CircularLogic extends Application_Model_Circular
{
    public function fetchDataTableSelect()
    {
        $columns = array('circular_created_date', 'circular_title', 'circular_status', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_CircularLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('circular_status != ?', 'D');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Circular:Edit")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"circular", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Circular:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"circular", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array(date('d-M-Y', strtotime($row->circular_created_date)), $row->circular_title, ($row->circular_status == 'A') ? 'Active' : 'Block', $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getActiveCirculars($limit = null) {
        $where = $this->select()->where('circular_status = ?', 'A')->order('circular_created_date desc');
        if(null != $limit) {
            $where->limit($limit);
        }
        return $this->fetchAll($where);
    }
    
    public function selectActiveCirculars() {
        $where = $this->select()->where('circular_status = ?', 'A')->order('circular_created_date desc');
        return $where;
    }
    
}

