<?php

class Application_Model_City extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_city';

    private $_id = null;

    private $_city_name = null;

    private $_city_desc = null;

    private $_city_image = null;

    private $_city_status = null;

    private $_city_updated_by = null;

    private $_city_updated_date = null;

    private $_city_created_by = null;

    private $_city_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get city_name method is stand for get the value of city_name.
     *
     * @var varchar city_name
     */
    public function get_city_name()
    {
        return $this->_city_name;
    }

    /**
     * set city_name method is stand for set the value of city_name.
     *
     * @var varchar city_name
     */
    public function set_city_name($value)
    {
        $this->_city_name = $value;
    }

    /**
     * get city_desc method is stand for get the value of city_desc.
     *
     * @var varchar city_desc
     */
    public function get_city_desc()
    {
        return $this->_city_desc;
    }

    /**
     * set city_desc method is stand for set the value of city_desc.
     *
     * @var varchar city_desc
     */
    public function set_city_desc($value)
    {
        $this->_city_desc = $value;
    }

    /**
     * get city_image method is stand for get the value of city_image.
     *
     * @var varchar city_image
     */
    public function get_city_image()
    {
        return $this->_city_image;
    }

    /**
     * set city_image method is stand for set the value of city_image.
     *
     * @var varchar city_image
     */
    public function set_city_image($value)
    {
        $this->_city_image = $value;
    }

    /**
     * get city_status method is stand for get the value of city_status.
     *
     * @var varchar city_status
     */
    public function get_city_status()
    {
        return $this->_city_status;
    }

    /**
     * set city_status method is stand for set the value of city_status.
     *
     * @var varchar city_status
     */
    public function set_city_status($value)
    {
        $this->_city_status = $value;
    }

    /**
     * get city_updated_by method is stand for get the value of city_updated_by.
     *
     * @var int city_updated_by
     */
    public function get_city_updated_by()
    {
        return (int) $this->_city_updated_by;
    }

    /**
     * set city_updated_by method is stand for set the value of city_updated_by.
     *
     * @var int city_updated_by
     */
    public function set_city_updated_by($value)
    {
        $this->_city_updated_by = (int) $value;
    }

    /**
     * get city_updated_date method is stand for get the value of city_updated_date.
     *
     * @var timestamp city_updated_date
     */
    public function get_city_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_city_updated_date));
    }

    /**
     * set city_updated_date method is stand for set the value of city_updated_date.
     *
     * @var timestamp city_updated_date
     */
    public function set_city_updated_date($value)
    {
        $this->_city_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get city_created_by method is stand for get the value of city_created_by.
     *
     * @var int city_created_by
     */
    public function get_city_created_by()
    {
        return (int) $this->_city_created_by;
    }

    /**
     * set city_created_by method is stand for set the value of city_created_by.
     *
     * @var int city_created_by
     */
    public function set_city_created_by($value)
    {
        $this->_city_created_by = (int) $value;
    }

    /**
     * get city_created_date method is stand for get the value of city_created_date.
     *
     * @var timestamp city_created_date
     */
    public function get_city_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_city_created_date));
    }

    /**
     * set city_created_date method is stand for set the value of city_created_date.
     *
     * @var timestamp city_created_date
     */
    public function set_city_created_date($value)
    {
        $this->_city_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_city by set id thru constructor.
     *
     * @var int id
     * @var varchar city_name
     * @var varchar city_desc
     * @var varchar city_image
     * @var varchar city_status
     * @var int city_updated_by
     * @var timestamp city_updated_date
     * @var int city_created_by
     * @var timestamp city_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_city_name($row->city_name);
          $this->set_city_desc($row->city_desc);
          $this->set_city_image($row->city_image);
          $this->set_city_status($row->city_status);
          $this->set_city_updated_by($row->city_updated_by);
          $this->set_city_updated_date($row->city_updated_date);
          $this->set_city_created_by($row->city_created_by);
          $this->set_city_created_date($row->city_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar city_name
     * @var varchar city_desc
     * @var varchar city_image
     * @var varchar city_status
     * @var int city_updated_by
     * @var int city_created_by
     */
    public function save()
    {
        $data = array(
          "city_name" => $this->get_city_name(),
          "city_desc" => $this->get_city_desc(),
          "city_image" => $this->get_city_image(),
          "city_status" => $this->get_city_status(),
          "city_updated_by" => $this->get_city_updated_by(),
          "city_created_by" => $this->get_city_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_city by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_city_name_by_id method is stand for get the value ofcity_name By id.
     *
     * @var varchar city_name
     */
    public function get_city_name_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_city_name();
    }

    /**
     * get_city_desc_by_id method is stand for get the value ofcity_desc By id.
     *
     * @var varchar city_desc
     */
    public function get_city_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_city_desc();
    }

    /**
     * get_city_image_by_id method is stand for get the value ofcity_image By id.
     *
     * @var varchar city_image
     */
    public function get_city_image_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_city_image();
    }

    /**
     * get_city_status_by_id method is stand for get the value ofcity_status By id.
     *
     * @var varchar city_status
     */
    public function get_city_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_city_status();
    }

    /**
     * get_city_updated_by_by_id method is stand for get the value ofcity_updated_by By
     * id.
     *
     * @var int city_updated_by
     */
    public function get_city_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_city_updated_by();
    }

    /**
     * get_city_updated_date_by_id method is stand for get the value
     * ofcity_updated_date By id.
     *
     * @var timestamp city_updated_date
     */
    public function get_city_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_city_updated_date()));
    }

    /**
     * get_city_created_by_by_id method is stand for get the value ofcity_created_by By
     * id.
     *
     * @var int city_created_by
     */
    public function get_city_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_city_created_by();
    }

    /**
     * get_city_created_date_by_id method is stand for get the value
     * ofcity_created_date By id.
     *
     * @var timestamp city_created_date
     */
    public function get_city_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_city_created_date()));
    }


}
