<?php

class Application_Model_CityLogic extends Application_Model_City
{
    
    public function fetchOrdered()
    {
        return $this->fetchAll($this->select()->order('city_name'));
    }
    
    public function fetchDataTableSelect() 
    {
        $columns = array('city_name', 'city_desc', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_CityLogic(-1)), $columns);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $enc = new Application_Model_Util_Encrypt();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("City:Edit")) {
                $action = '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"city", "action"=>"edit", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Edit" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("City:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"city", "action"=>"delete", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->city_name, $row->city_desc, $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getIdByTitle($city)
    {
        $select = $this->select()->where('lower(replace(city_name, \' \', \'-\'))=?', $city);
        $row = $this->fetchRow($select);
        $id = ($row!=null) ? (int)$row->id : -1;
        return $id;
    }
    
}

