<?php

class Application_Model_Config extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_config';

    private $_id = null;

    private $_config_key = null;

    private $_config_value = null;

    private $_config_serialize = null;

    private $_config_updated_by = null;

    private $_config_updated_date = null;

    private $_config_created_by = null;

    private $_config_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get config_key method is stand for get the value of config_key.
     *
     * @var varchar config_key
     */
    public function get_config_key()
    {
        return $this->_config_key;
    }

    /**
     * set config_key method is stand for set the value of config_key.
     *
     * @var varchar config_key
     */
    public function set_config_key($value)
    {
        $this->_config_key = $value;
    }

    /**
     * get config_value method is stand for get the value of config_value.
     *
     * @var text config_value
     */
    public function get_config_value()
    {
        return $this->_config_value;
    }

    /**
     * set config_value method is stand for set the value of config_value.
     *
     * @var text config_value
     */
    public function set_config_value($value)
    {
        $this->_config_value = $value;
    }

    /**
     * get config_serialize method is stand for get the value of config_serialize.
     *
     * @var tinyint config_serialize
     */
    public function get_config_serialize()
    {
        return $this->_config_serialize;
    }

    /**
     * set config_serialize method is stand for set the value of config_serialize.
     *
     * @var tinyint config_serialize
     */
    public function set_config_serialize($value)
    {
        $this->_config_serialize = $value;
    }

    /**
     * get config_updated_by method is stand for get the value of config_updated_by.
     *
     * @var int config_updated_by
     */
    public function get_config_updated_by()
    {
        return (int) $this->_config_updated_by;
    }

    /**
     * set config_updated_by method is stand for set the value of config_updated_by.
     *
     * @var int config_updated_by
     */
    public function set_config_updated_by($value)
    {
        $this->_config_updated_by = (int) $value;
    }

    /**
     * get config_updated_date method is stand for get the value of
     * config_updated_date.
     *
     * @var timestamp config_updated_date
     */
    public function get_config_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_config_updated_date));
    }

    /**
     * set config_updated_date method is stand for set the value of
     * config_updated_date.
     *
     * @var timestamp config_updated_date
     */
    public function set_config_updated_date($value)
    {
        $this->_config_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get config_created_by method is stand for get the value of config_created_by.
     *
     * @var int config_created_by
     */
    public function get_config_created_by()
    {
        return (int) $this->_config_created_by;
    }

    /**
     * set config_created_by method is stand for set the value of config_created_by.
     *
     * @var int config_created_by
     */
    public function set_config_created_by($value)
    {
        $this->_config_created_by = (int) $value;
    }

    /**
     * get config_created_date method is stand for get the value of
     * config_created_date.
     *
     * @var timestamp config_created_date
     */
    public function get_config_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_config_created_date));
    }

    /**
     * set config_created_date method is stand for set the value of
     * config_created_date.
     *
     * @var timestamp config_created_date
     */
    public function set_config_created_date($value)
    {
        $this->_config_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_config by set id thru constructor.
     *
     * @var int id
     * @var varchar config_key
     * @var text config_value
     * @var tinyint config_serialize
     * @var int config_updated_by
     * @var timestamp config_updated_date
     * @var int config_created_by
     * @var timestamp config_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_config_key($row->config_key);
          $this->set_config_value($row->config_value);
          $this->set_config_serialize($row->config_serialize);
          $this->set_config_updated_by($row->config_updated_by);
          $this->set_config_updated_date($row->config_updated_date);
          $this->set_config_created_by($row->config_created_by);
          $this->set_config_created_date($row->config_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar config_key
     * @var text config_value
     * @var tinyint config_serialize
     * @var int config_updated_by
     * @var int config_created_by
     */
    public function save()
    {
        $data = array(
          "config_key" => $this->get_config_key(),
          "config_value" => $this->get_config_value(),
          "config_serialize" => $this->get_config_serialize(),
          "config_updated_by" => $this->get_config_updated_by(),
          "config_created_by" => $this->get_config_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_config by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_config_key_by_id method is stand for get the value ofconfig_key By id.
     *
     * @var varchar config_key
     */
    public function get_config_key_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_config_key();
    }

    /**
     * get_config_value_by_id method is stand for get the value ofconfig_value By id.
     *
     * @var text config_value
     */
    public function get_config_value_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_config_value();
    }

    /**
     * get_config_serialize_by_id method is stand for get the value ofconfig_serialize
     * By id.
     *
     * @var tinyint config_serialize
     */
    public function get_config_serialize_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_config_serialize();
    }

    /**
     * get_config_updated_by_by_id method is stand for get the value
     * ofconfig_updated_by By id.
     *
     * @var int config_updated_by
     */
    public function get_config_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_config_updated_by();
    }

    /**
     * get_config_updated_date_by_id method is stand for get the value
     * ofconfig_updated_date By id.
     *
     * @var timestamp config_updated_date
     */
    public function get_config_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_config_updated_date()));
    }

    /**
     * get_config_created_by_by_id method is stand for get the value
     * ofconfig_created_by By id.
     *
     * @var int config_created_by
     */
    public function get_config_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_config_created_by();
    }

    /**
     * get_config_created_date_by_id method is stand for get the value
     * ofconfig_created_date By id.
     *
     * @var timestamp config_created_date
     */
    public function get_config_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_config_created_date()));
    }


}
