<?php

class Application_Model_ConfigLogic extends Application_Model_Config
{

    public function getConfigElementsForCache()
    {
        foreach($this->fetchAll() as $result)
        {
            if($result['config_serialize']) {
                $configs[$result['config_key']] = unserialize($result['config_value']);
            }else {
                $configs[$result['config_key']] = $result['config_value'];
            }
        }
        return $configs;
    }
    
    public function fetchDataTableSelect() 
    {
        $columns = array('config_key', 'config_value', 'config_serialize', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_ConfigLogic(-1)), $columns);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $enc = new Application_Model_Util_Encrypt();
        foreach($rows as $row)
        {
            if(Application_Model_RolePermissionLogic::isPermitted('Config:Edit')) { 
                $action = '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"config", "action"=>"edit", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Edit" class="btn btn-info" /></a> ';
            }
            $results[$i] = array($row->config_key, $row->config_value, ($row->config_serialize) ? 'true' : 'false', $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getSiteVisitors() 
    {
        $where = $this->select()->where('config_key = ?', 'SITE_VISITORS');
        $row = $this->fetchRow($where);
        return $row['config_value'];
    }
    
    public function increaseSiteVisitors() 
    {
        $where = $this->select()->where('config_key = ?', 'SITE_VISITORS');
        $row = $this->fetchRow($where);
        $obj_config = new Application_Model_ConfigLogic($row['id']);
        $obj_config->set_config_value((int)$obj_config->get_config_value() + 1);
        $obj_config->save();
    }

}

