<?php

class Application_Model_ContactLogic extends Application_Model_Contact
{
    
    public function insertContact($name, $email, $phone, $msg, $listId = 0)
    {
        $this->set_id(-1);
        $this->set_contact_name($name);
        $this->set_contact_email($email);
        $this->set_contact_phone($phone);
        $this->set_contact_message($msg);
        $this->set_contact_list($listId);
        $this->set_contact_is_view(false);
        $this->set_contact_status('A');
        $user = new Application_Model_UserLogic(-1);
        $this->set_contact_created_by($user->getLoggedInUserId());
        $this->set_contact_updated_by($user->getLoggedInUserId());
        $this->save();
    }
    
    public function fetchDataTableSelect($listId = 0) 
    {
        $columns = array('contact_created_date', 'contact_name', 'contact_email', 'contact_phone', 'contact_subject', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_ContactLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('contact_status = ?', 'A');
        $where->order('contact_created_date desc');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Contact:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"contact", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array(date(Application_Model_Cache_Config::getConfig("DEFAULT_DISPLAY_FORMAT"), strtotime($row->contact_created_date)), $row->contact_name, $row->contact_email, $row->contact_phone, $row->contact_query, $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }


}

