<?php

class Application_Model_Contact extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_contact';

    private $_id = null;

    private $_contact_name = null;

    private $_contact_email = null;

    private $_contact_phone = null;

    private $_contact_message = null;

    private $_contact_list = null;

    private $_contact_is_view = null;

    private $_contact_status = null;

    private $_contact_updated_by = null;

    private $_contact_updated_date = null;

    private $_contact_created_by = null;

    private $_contact_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get contact_name method is stand for get the value of contact_name.
     *
     * @var varchar contact_name
     */
    public function get_contact_name()
    {
        return $this->_contact_name;
    }

    /**
     * set contact_name method is stand for set the value of contact_name.
     *
     * @var varchar contact_name
     */
    public function set_contact_name($value)
    {
        $this->_contact_name = $value;
    }

    /**
     * get contact_email method is stand for get the value of contact_email.
     *
     * @var varchar contact_email
     */
    public function get_contact_email()
    {
        return $this->_contact_email;
    }

    /**
     * set contact_email method is stand for set the value of contact_email.
     *
     * @var varchar contact_email
     */
    public function set_contact_email($value)
    {
        $this->_contact_email = $value;
    }

    /**
     * get contact_phone method is stand for get the value of contact_phone.
     *
     * @var varchar contact_phone
     */
    public function get_contact_phone()
    {
        return $this->_contact_phone;
    }

    /**
     * set contact_phone method is stand for set the value of contact_phone.
     *
     * @var varchar contact_phone
     */
    public function set_contact_phone($value)
    {
        $this->_contact_phone = $value;
    }

    /**
     * get contact_message method is stand for get the value of contact_message.
     *
     * @var varchar contact_message
     */
    public function get_contact_message()
    {
        return $this->_contact_message;
    }

    /**
     * set contact_message method is stand for set the value of contact_message.
     *
     * @var varchar contact_message
     */
    public function set_contact_message($value)
    {
        $this->_contact_message = $value;
    }

    /**
     * get contact_list method is stand for get the value of contact_list.
     *
     * @var int contact_list
     */
    public function get_contact_list()
    {
        return (int) $this->_contact_list;
    }

    /**
     * set contact_list method is stand for set the value of contact_list.
     *
     * @var int contact_list
     */
    public function set_contact_list($value)
    {
        $this->_contact_list = (int) $value;
    }

    /**
     * get contact_is_view method is stand for get the value of contact_is_view.
     *
     * @var tinyint contact_is_view
     */
    public function get_contact_is_view()
    {
        return $this->_contact_is_view;
    }

    /**
     * set contact_is_view method is stand for set the value of contact_is_view.
     *
     * @var tinyint contact_is_view
     */
    public function set_contact_is_view($value)
    {
        $this->_contact_is_view = $value;
    }

    /**
     * get contact_status method is stand for get the value of contact_status.
     *
     * @var varchar contact_status
     */
    public function get_contact_status()
    {
        return $this->_contact_status;
    }

    /**
     * set contact_status method is stand for set the value of contact_status.
     *
     * @var varchar contact_status
     */
    public function set_contact_status($value)
    {
        $this->_contact_status = $value;
    }

    /**
     * get contact_updated_by method is stand for get the value of contact_updated_by.
     *
     * @var int contact_updated_by
     */
    public function get_contact_updated_by()
    {
        return (int) $this->_contact_updated_by;
    }

    /**
     * set contact_updated_by method is stand for set the value of contact_updated_by.
     *
     * @var int contact_updated_by
     */
    public function set_contact_updated_by($value)
    {
        $this->_contact_updated_by = (int) $value;
    }

    /**
     * get contact_updated_date method is stand for get the value of
     * contact_updated_date.
     *
     * @var timestamp contact_updated_date
     */
    public function get_contact_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_contact_updated_date));
    }

    /**
     * set contact_updated_date method is stand for set the value of
     * contact_updated_date.
     *
     * @var timestamp contact_updated_date
     */
    public function set_contact_updated_date($value)
    {
        $this->_contact_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get contact_created_by method is stand for get the value of contact_created_by.
     *
     * @var int contact_created_by
     */
    public function get_contact_created_by()
    {
        return (int) $this->_contact_created_by;
    }

    /**
     * set contact_created_by method is stand for set the value of contact_created_by.
     *
     * @var int contact_created_by
     */
    public function set_contact_created_by($value)
    {
        $this->_contact_created_by = (int) $value;
    }

    /**
     * get contact_created_date method is stand for get the value of
     * contact_created_date.
     *
     * @var timestamp contact_created_date
     */
    public function get_contact_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_contact_created_date));
    }

    /**
     * set contact_created_date method is stand for set the value of
     * contact_created_date.
     *
     * @var timestamp contact_created_date
     */
    public function set_contact_created_date($value)
    {
        $this->_contact_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_contact by set id thru constructor.
     *
     * @var int id
     * @var varchar contact_name
     * @var varchar contact_email
     * @var varchar contact_phone
     * @var varchar contact_message
     * @var int contact_list
     * @var tinyint contact_is_view
     * @var varchar contact_status
     * @var int contact_updated_by
     * @var timestamp contact_updated_date
     * @var int contact_created_by
     * @var timestamp contact_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_contact_name($row->contact_name);
          $this->set_contact_email($row->contact_email);
          $this->set_contact_phone($row->contact_phone);
          $this->set_contact_message($row->contact_message);
          $this->set_contact_list($row->contact_list);
          $this->set_contact_is_view($row->contact_is_view);
          $this->set_contact_status($row->contact_status);
          $this->set_contact_updated_by($row->contact_updated_by);
          $this->set_contact_updated_date($row->contact_updated_date);
          $this->set_contact_created_by($row->contact_created_by);
          $this->set_contact_created_date($row->contact_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar contact_name
     * @var varchar contact_email
     * @var varchar contact_phone
     * @var varchar contact_message
     * @var int contact_list
     * @var tinyint contact_is_view
     * @var varchar contact_status
     * @var int contact_updated_by
     * @var int contact_created_by
     */
    public function save()
    {
        $data = array(
          "contact_name" => $this->get_contact_name(),
          "contact_email" => $this->get_contact_email(),
          "contact_phone" => $this->get_contact_phone(),
          "contact_message" => $this->get_contact_message(),
          "contact_list" => $this->get_contact_list(),
          "contact_is_view" => $this->get_contact_is_view(),
          "contact_status" => $this->get_contact_status(),
          "contact_updated_by" => $this->get_contact_updated_by(),
          "contact_created_by" => $this->get_contact_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_contact by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_contact_name_by_id method is stand for get the value ofcontact_name By id.
     *
     * @var varchar contact_name
     */
    public function get_contact_name_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_contact_name();
    }

    /**
     * get_contact_email_by_id method is stand for get the value ofcontact_email By id.
     *
     * @var varchar contact_email
     */
    public function get_contact_email_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_contact_email();
    }

    /**
     * get_contact_phone_by_id method is stand for get the value ofcontact_phone By id.
     *
     * @var varchar contact_phone
     */
    public function get_contact_phone_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_contact_phone();
    }

    /**
     * get_contact_message_by_id method is stand for get the value ofcontact_message By
     * id.
     *
     * @var varchar contact_message
     */
    public function get_contact_message_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_contact_message();
    }

    /**
     * get_contact_list_by_id method is stand for get the value ofcontact_list By id.
     *
     * @var int contact_list
     */
    public function get_contact_list_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_contact_list();
    }

    /**
     * get_contact_is_view_by_id method is stand for get the value ofcontact_is_view By
     * id.
     *
     * @var tinyint contact_is_view
     */
    public function get_contact_is_view_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_contact_is_view();
    }

    /**
     * get_contact_status_by_id method is stand for get the value ofcontact_status By
     * id.
     *
     * @var varchar contact_status
     */
    public function get_contact_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_contact_status();
    }

    /**
     * get_contact_updated_by_by_id method is stand for get the value
     * ofcontact_updated_by By id.
     *
     * @var int contact_updated_by
     */
    public function get_contact_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_contact_updated_by();
    }

    /**
     * get_contact_updated_date_by_id method is stand for get the value
     * ofcontact_updated_date By id.
     *
     * @var timestamp contact_updated_date
     */
    public function get_contact_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_contact_updated_date()));
    }

    /**
     * get_contact_created_by_by_id method is stand for get the value
     * ofcontact_created_by By id.
     *
     * @var int contact_created_by
     */
    public function get_contact_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_contact_created_by();
    }

    /**
     * get_contact_created_date_by_id method is stand for get the value
     * ofcontact_created_date By id.
     *
     * @var timestamp contact_created_date
     */
    public function get_contact_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_contact_created_date()));
    }


}
