<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Activity
 *
 * @author Akhil Kumar
 */
class Application_Model_Download extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_download';

    private $_id = null;

    private $_download_title = null;

    private $_download_desc = null;

    private $_download_file = null;

    private $_download_status = null;

    private $_download_updated_by = null;

    private $_download_updated_date = null;

    private $_download_created_by = null;

    private $_download_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get download_title method is stand for get the value of download_title.
     *
     * @var varchar download_title
     */
    public function get_download_title()
    {
        return $this->_download_title;
    }

    /**
     * set download_title method is stand for set the value of download_title.
     *
     * @var varchar download_title
     */
    public function set_download_title($value)
    {
        $this->_download_title = $value;
    }

    /**
     * get download_desc method is stand for get the value of download_desc.
     *
     * @var varchar download_desc
     */
    public function get_download_desc()
    {
        return $this->_download_desc;
    }

    /**
     * set download_desc method is stand for set the value of download_desc.
     *
     * @var varchar download_desc
     */
    public function set_download_desc($value)
    {
        $this->_download_desc = $value;
    }

    /**
     * get download_file method is stand for get the value of download_file.
     *
     * @var varchar download_file
     */
    public function get_download_file()
    {
        return $this->_download_file;
    }

    /**
     * set download_file method is stand for set the value of download_file.
     *
     * @var varchar download_file
     */
    public function set_download_file($value)
    {
        $this->_download_file = $value;
    }

    /**
     * get download_status method is stand for get the value of download_status.
     *
     * @var varchar download_status
     */
    public function get_download_status()
    {
        return $this->_download_status;
    }

    /**
     * set download_status method is stand for set the value of download_status.
     *
     * @var varchar download_status
     */
    public function set_download_status($value)
    {
        $this->_download_status = $value;
    }

    /**
     * get download_updated_by method is stand for get the value of
     * download_updated_by.
     *
     * @var int download_updated_by
     */
    public function get_download_updated_by()
    {
        return (int) $this->_download_updated_by;
    }

    /**
     * set download_updated_by method is stand for set the value of
     * download_updated_by.
     *
     * @var int download_updated_by
     */
    public function set_download_updated_by($value)
    {
        $this->_download_updated_by = (int) $value;
    }

    /**
     * get download_updated_date method is stand for get the value of
     * download_updated_date.
     *
     * @var timestamp download_updated_date
     */
    public function get_download_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_download_updated_date));
    }

    /**
     * set download_updated_date method is stand for set the value of
     * download_updated_date.
     *
     * @var timestamp download_updated_date
     */
    public function set_download_updated_date($value)
    {
        $this->_download_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get download_created_by method is stand for get the value of
     * download_created_by.
     *
     * @var int download_created_by
     */
    public function get_download_created_by()
    {
        return (int) $this->_download_created_by;
    }

    /**
     * set download_created_by method is stand for set the value of
     * download_created_by.
     *
     * @var int download_created_by
     */
    public function set_download_created_by($value)
    {
        $this->_download_created_by = (int) $value;
    }

    /**
     * get download_created_date method is stand for get the value of
     * download_created_date.
     *
     * @var timestamp download_created_date
     */
    public function get_download_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_download_created_date));
    }

    /**
     * set download_created_date method is stand for set the value of
     * download_created_date.
     *
     * @var timestamp download_created_date
     */
    public function set_download_created_date($value)
    {
        $this->_download_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_download by set id thru constructor.
     *
     * @var int id
     * @var varchar download_title
     * @var varchar download_desc
     * @var varchar download_file
     * @var varchar download_status
     * @var int download_updated_by
     * @var timestamp download_updated_date
     * @var int download_created_by
     * @var timestamp download_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_download_title($row->download_title);
          $this->set_download_desc($row->download_desc);
          $this->set_download_file($row->download_file);
          $this->set_download_status($row->download_status);
          $this->set_download_updated_by($row->download_updated_by);
          $this->set_download_updated_date($row->download_updated_date);
          $this->set_download_created_by($row->download_created_by);
          $this->set_download_created_date($row->download_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar download_title
     * @var varchar download_desc
     * @var varchar download_file
     * @var varchar download_status
     * @var int download_updated_by
     * @var int download_created_by
     */
    public function save()
    {
        $data = array(
          "download_title" => $this->get_download_title(),
          "download_desc" => $this->get_download_desc(),
          "download_file" => $this->get_download_file(),
          "download_status" => $this->get_download_status(),
          "download_updated_by" => $this->get_download_updated_by(),
          "download_created_by" => $this->get_download_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_download by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_download_title_by_id method is stand for get the value ofdownload_title By
     * id.
     *
     * @var varchar download_title
     */
    public function get_download_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_download_title();
    }

    /**
     * get_download_desc_by_id method is stand for get the value ofdownload_desc By id.
     *
     * @var varchar download_desc
     */
    public function get_download_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_download_desc();
    }

    /**
     * get_download_file_by_id method is stand for get the value ofdownload_file By id.
     *
     * @var varchar download_file
     */
    public function get_download_file_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_download_file();
    }

    /**
     * get_download_status_by_id method is stand for get the value ofdownload_status By
     * id.
     *
     * @var varchar download_status
     */
    public function get_download_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_download_status();
    }

    /**
     * get_download_updated_by_by_id method is stand for get the value
     * ofdownload_updated_by By id.
     *
     * @var int download_updated_by
     */
    public function get_download_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_download_updated_by();
    }

    /**
     * get_download_updated_date_by_id method is stand for get the value
     * ofdownload_updated_date By id.
     *
     * @var timestamp download_updated_date
     */
    public function get_download_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_download_updated_date()));
    }

    /**
     * get_download_created_by_by_id method is stand for get the value
     * ofdownload_created_by By id.
     *
     * @var int download_created_by
     */
    public function get_download_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_download_created_by();
    }

    /**
     * get_download_created_date_by_id method is stand for get the value
     * ofdownload_created_date By id.
     *
     * @var timestamp download_created_date
     */
    public function get_download_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_download_created_date()));
    }


}
