<?php

class Application_Model_DownloadLogic extends Application_Model_Download
{
    public function fetchDataTableSelect()
    {
        $columns = array('download_created_date', 'download_title', 'download_status', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_DownloadLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('download_status != ?', 'D');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Download:Edit")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"download", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Download:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"download", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array(date('d-M-Y', strtotime($row->download_created_date)), $row->download_title, ($row->download_status == 'A') ? 'Active' : 'Block', $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getActiveDownloads($limit = null) {
        $where = $this->select()->where('download_status = ?', 'A')->order('download_created_date desc');
        if(null != $limit) {
            $where->limit($limit);
        }
        return $this->fetchAll($where);
    }
    
    public function selectActiveDownloads() {
        $where = $this->select()->where('download_status = ?', 'A')->order('download_created_date desc');
        return $where;
    }
    
}

