<?php

class Application_Model_Email_Factory extends Application_Model_Email_Util
{
    
    public function sendStatusChangeEmail($to, $subject, $message, $intimateToAdmin)
    {
        $admin = null;
        if($intimateToAdmin) {
            $admin = Application_Model_Cache_Config::getConfig("DEFAULT_SEND_MAIL_ADDRESS_FOR_LOG");
        }
        $this->send($to, $subject, $message, $admin);
    }
    
    public function sendErrors($message, $exception, $params)
    {
        
        $error = "<h1>An error occurred</h1><h2>".$message."</h2><h3>Exception information:</h3>
        <p><b>Message:</b> ".$exception->getMessage()."</p><h3>Stack trace:</h3><pre>".$exception->getTraceAsString().
        "</pre><h3>Request Parameters:</h3><pre>".var_export($params, true)."</pre>";

        $this->send(Application_Model_Cache_Config::getConfig('DEFAULT_SEND_MAIL_ADDRESS_FOR_LOG'), 'Error at '.  date('d-M-Y (H:i:s)'). '. --'.$exception->getMessage(), $error, 'error@selectsurveyors.in', 'Creation Error');
    }

    public function sendWorkAllocationEmail($id, $isEdit = false)
    {
        $obj_work = new Application_Model_WorkLogic($id);
        Zend_Debug::dump($obj_work);
        $allocatedUser = new Application_Model_UserLogic((!$isEdit) ? $obj_work->get_work_created_by() : $obj_work->get_work_updated_by());
        $subject = (!isEdit) ? "New work has been allocated by ".$allocatedUser->get_user_name()." at ".$obj_work->get_work_created_date() : "Allocated work has been updated by ".$allocatedUser->get_user_name()." at ".$obj_work->get_work_updated_date();
        $message = "Dear User,<br /><br />Please check the enclosed details of allocated work:<br /><br /><b>Timeline: </b>".$obj_work->get_work_from_date()."-".$obj_work->get_work_to_date()
                . "<br /><b>Work: </b>".$obj_work->get_work_title()
                . "<br /><b>Priority: </b>".  Application_Model_WorkLogic::$priority[$obj_work->get_work_priority()]
                . "<br /><b>Description: </b>".$obj_work->get_work_description()
                . "<br /><b>Remarks: </b>".$obj_work->get_work_remarks()
                . "<br /><br />Any other concern/query,  please let me know.";
        $obj_user = new Application_Model_UserLogic(-1);
        $to = array();
        if($obj_work->get_work_role_id() > 0) {
            foreach($obj_user->fetchActiveUsersByRole($obj_work->get_work_role_id()) as $user) {
                array_push($to, $user->user_email);
            }
        }
        else if($obj_work->get_work_user_id() > 0) {
            array_push($to, $obj_user->get_user_email_by_id($obj_work->get_work_user_id()));
        }
        array_push($to, $obj_user->get_user_email_by_id($obj_work->get_work_created_by()));
        array_push($to, $obj_user->get_user_email_by_id($obj_work->get_work_updated_by()));
        $this->send($to, $subject, $message);
    }
    
    public function sendWorkAllocationStatusEmail($id)
    {
        $obj_work = new Application_Model_WorkLogic($id);
        $statusUser = new Application_Model_UserLogic($obj_work->get_work_updated_by());
        $subject = "Status has been updated for allocated work by ".$statusUser->get_user_name()." at ".$obj_work->get_work_updated_date();
        $message = "Dear User,<br /><br />Please check the enclosed details of allocated work:<br /><br /><b>Timeline: </b>".$obj_work->get_work_from_date()."-".$obj_work->get_work_to_date()
                . "<br /><b>Work: </b>".$obj_work->get_work_title()
                . "<br /><b>Priority: </b>".  Application_Model_WorkLogic::$priority[$obj_work->get_work_priority()]
                . "<br /><b>Description: </b>".$obj_work->get_work_description()
                . "<br /><b>Remarks: </b>".$obj_work->get_work_remarks()
                . "<br /><br />Any other concern/query,  please let me know.";
        $obj_user = new Application_Model_UserLogic(-1);
        $to = array();
        if($obj_work->get_work_role_id() > 0) {
            foreach($obj_user->fetchActiveUsersByRole($obj_work->get_work_role_id()) as $user) {
                array_push($to, $user->user_email);
            }
        }
        else if($obj_work->get_work_user_id() > 0) {
            array_push($to, $obj_user->get_user_email_by_id($obj_work->get_work_user_id()));
        }
        array_push($to, $obj_user->get_user_email_by_id($obj_work->get_work_created_by()));
        array_push($to, $obj_user->get_user_email_by_id($obj_work->get_work_updated_by()));
        $this->send($to, $subject, $message);
    }

}

