<?php

class Application_Model_Email_Util
{
    
    private function getManualSMTP()
    {
        //configure smtp
        $config = array('ssl' => Application_Model_Cache_Config::getConfig('SMTP_SSL'),
                'auth' => Application_Model_Cache_Config::getConfig('SMTP_AUTH'),
                'username' => Application_Model_Cache_Config::getConfig('SMTP_USER'),
                'password' => Application_Model_Cache_Config::getConfig('SMTP_PASS'));

        $transport = new Zend_Mail_Transport_Smtp(Application_Model_Cache_Config::getConfig('SMTP_ADD'), $config);
        return $transport;
    }
    
    public function send($toEMail, $subject, $body, $cc = null, $fromEmail = null, $fromName = null)
    {
        $mail = new Zend_Mail('utf-8');

        $fromEmail = ($fromEmail == null) ? Application_Model_Cache_Config::getConfig('DEFAULT_SENDER_MAIL_ADDRESS') : $fromEmail;
        $fromName = ($fromName == null) ? Application_Model_Cache_Config::getConfig('DEFAULT_SENDER_MAIL_NAME') : $fromName;
        // configure base stuff
        
        if(is_array($toEMail)) {
            foreach($toEMail as $email) {
                $mail->addTo($email);
            }
        }else {
            $mail->addTo($toEMail);
        }
        
        $mail->addCc(Application_Model_Cache_Config::getConfig('SMTP_USER'));
        $mail->setSubject($subject);
        $mail->setFrom($fromEmail,$fromName);
        $mail->setBodyHtml($body.Application_Model_Cache_Config::getConfig("EMAIL_FOOTER"));
        
        if(null != $cc) {
            $mail->addCc($cc);
        }
        $emailLogId = null;
        if(Application_Model_Cache_Config::getConfig('MONITOR_EMAIL_LOG') == 'true') {
            $obj_email = new Application_Model_EmailLog(-1);
            $obj_email->set_log_body($body.Application_Model_Cache_Config::getConfig("EMAIL_FOOTER"));
            $obj_email->set_log_email_from($fromEmail);
            $obj_email->set_log_email_from_name($fromName);
            $obj_email->set_log_email_to(is_array($toEMail) ? implode(', ', $toEMail) : $toEMail);
            $obj_email->set_log_email_cc(($cc != null) ? $cc : '');
            $obj_email->set_log_email_bcc('');
            $obj_email->set_log_send(date('Y-m-d H:i:s'));
            $obj_email->set_log_subject($subject);
            $obj_email->set_log_status('Initiated');
            $user = new Application_Model_UserLogic(-1);
            $obj_email->set_log_created_by(($user->getLoggedInUser() != null) ? $user->getLoggedInUser()->get_id() : 0);
            $obj_email->save();
            $emailLogId = $obj_email->getAdapter()->lastInsertId();
        }
        
        if(Application_Model_Cache_Config::getConfig('EMAIL_ACTIVE')) {
            if(null != $emailLogId) {
                $obj_email = new Application_Model_EmailLogLogic($emailLogId);
                $obj_email->set_log_status('Send');
                $obj_email->save();
            }
            if(Application_Model_Cache_Config::getConfig('USE_MANUAL_SMTP')) {
                $mail->send($this->getManualSMTP());
            }else {
                $mail->send();
            }
        }else {
            if(null != $emailLogId) {
                $obj_email = new Application_Model_EmailLogLogic($emailLogId);
                $obj_email->set_log_status('Not Send');
                $obj_email->save();
            }
        }
        
    }
    
    function sendMultiEmail($id, $subject, $tos, $ccs, $bccs, $message, $from = null) {
        $obj_email = new Application_Model_EmailLogLogic($id);
        $mail = new Zend_Mail();
        $mail->setBodyHtml($message.Application_Model_Cache_Config::getConfig("EMAIL_FOOTER"));
        $mail->setFrom($obj_email->get_log_email_from(), $obj_email->get_log_email_from_name());
        foreach($tos as $to) {
            $mail->addTo($to);
        }
        foreach($ccs as $cc) {
            $mail->addCc($cc);
        }
        foreach($bccs as $bcc) {
            $mail->addBcc($bcc);
        }
        $mail->addCc(Application_Model_Cache_Config::getConfig('SMTP_USER'));
        $mail->setSubject($subject);
        $obj_attach = new Application_Model_EmailAttachmentLogic(-1);
        foreach($obj_attach->getAttachmentsByEmail($id) as $attachment) {
            $content = file_get_contents($attachment->attachment_path); // e.g. ("attachment/abc.pdf")
            $at = new Zend_Mime_Part($content);
            $at->type = mime_content_type($attachment->attachment_path);
            $at->disposition = Zend_Mime::DISPOSITION_ATTACHMENT;
            $at->encoding = Zend_Mime::ENCODING_BASE64;
            if(count(explode('/', $attachment->attachment_path)) > 0) {
                $elements = explode('/', $attachment->attachment_path);
                $totalElement = count($elements);
                $at->filename = $elements[$totalElement-1];
            }else {
                $at->filename = $attachment->attachment_path;
            }
            $mail->addAttachment($at);
        }
        try {
            if(Application_Model_Cache_Config::getConfig('EMAIL_ACTIVE')) {
                if(Application_Model_Cache_Config::getConfig('USE_MANUAL_SMTP')) {
                    $mail->send($this->getManualSMTP());
                }else {
                    $mail->send();
                }
            }
        }catch(Zend_Mail_Exception $e) {
             echo $e;
        }
        $obj_email->set_log_email_to(implode(', ', $tos));
        $obj_email->set_log_email_cc(implode(', ', $ccs));
        $obj_email->set_log_email_bcc(implode(', ', $bccs));
        $obj_email->set_log_subject($subject);
        $obj_email->set_log_body($message.Application_Model_Cache_Config::getConfig("EMAIL_FOOTER"));
        $user = new Zend_Session_Namespace('user');
        $obj_email->set_log_status('Send');
        $obj_email->set_log_created_by((int)$user->id);
        if(Application_Model_Cache_Config::getConfig('MONITOR_EMAIL_LOG') == 'true') {
            $obj_email->save();
        }else {
            $obj_email->remove();
        }
    }
    
    public function sendScheduleEmail($id)
    {
        $obj_email = new Application_Model_EmailScheduleLogic($id);
        $mail = new Zend_Mail();
        $mail->setBodyHtml($obj_email->get_email_body().Application_Model_Cache_Config::getConfig("EMAIL_FOOTER"));
        $mail->setFrom($obj_email->get_email_from(), $obj_email->get_email_from_name());
        foreach(explode(',', $obj_email->get_email_to()) as $to) {
            if(filter_var(trim($to), FILTER_VALIDATE_EMAIL)) {
                $mail->addTo(trim($to));
            }
        }
        foreach(explode(',', $obj_email->get_email_cc()) as $cc) {
            if(filter_var(trim($cc), FILTER_VALIDATE_EMAIL)) {
                $mail->addCc(trim($cc));
            }
        }
        foreach(explode(',', $obj_email->get_email_bcc()) as $bcc) {
            if(filter_var(trim($bcc), FILTER_VALIDATE_EMAIL)) {
                $mail->addBcc(trim($bcc));
            }
        }
        $mail->addCc(Application_Model_Cache_Config::getConfig('SMTP_USER'));
        $mail->setSubject($obj_email->get_email_subject());
        
        $obj_log = new Application_Model_EmailLogLogic(-1);
        $obj_log->set_log_email_to($obj_email->get_email_to());
        $obj_log->set_log_email_cc($obj_email->get_email_cc());
        $obj_log->set_log_email_bcc($obj_email->get_email_bcc());
        $obj_log->set_log_email_from($obj_email->get_email_from());
        $obj_log->set_log_email_from_name($obj_email->get_email_from_name());
        $obj_log->set_log_subject($obj_email->get_email_subject());
        $obj_log->set_log_body($obj_email->get_email_body());
        $obj_log->set_log_created_by($obj_email->get_email_created_by());
        $obj_log->set_log_updated_by($obj_email->get_email_updated_by());
        $obj_log->set_log_send(date('Y-m-d H:i:s'));
        //Zend_Debug::dump($mail);
        try {
            if(Application_Model_Cache_Config::getConfig('EMAIL_ACTIVE')) {
                if(Application_Model_Cache_Config::getConfig('USE_MANUAL_SMTP')) {
                    $mail->send($this->getManualSMTP());
                }else {
                    $mail->send();
                }
                $obj_log->set_log_status('Send');
            }
        }catch(Zend_Mail_Exception $e) {
            $obj_log->set_log_status('Not Send');
            echo $e;
        }
        
        if(Application_Model_Cache_Config::getConfig('MONITOR_EMAIL_LOG') == 'true') {
            $obj_log->save();
        }
        $obj_email->set_email_priority(-1);
        $obj_email->save();
    }
    
}

