<?php

class Application_Model_EmailAttachment extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_email_attachment_log';

    private $_id = null;

    private $_email_id = null;

    private $_attachment_path = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get email_id method is stand for get the value of email_id.
     *
     * @var int email_id
     */
    public function get_email_id()
    {
        return (int) $this->_email_id;
    }

    /**
     * set email_id method is stand for set the value of email_id.
     *
     * @var int email_id
     */
    public function set_email_id($value)
    {
        $this->_email_id = (int) $value;
    }

    /**
     * get attachment_path method is stand for get the value of attachment_path.
     *
     * @var varchar attachment_path
     */
    public function get_attachment_path()
    {
        return $this->_attachment_path;
    }

    /**
     * set attachment_path method is stand for set the value of attachment_path.
     *
     * @var varchar attachment_path
     */
    public function set_attachment_path($value)
    {
        $this->_attachment_path = $value;
    }

    /**
     * fetch data from eauction_email_attachment by set id thru constructor.
     *
     * @var int id
     * @var int email_id
     * @var varchar attachment_path
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_email_id($row->email_id);
          $this->set_attachment_path($row->attachment_path);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var int email_id
     * @var varchar attachment_path
     */
    public function save()
    {
        $data = array(
          "email_id" => $this->get_email_id(),
          "attachment_path" => $this->get_attachment_path());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from eauction_email_attachment by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_email_id_by_id method is stand for get the value ofemail_id By id.
     *
     * @var int email_id
     */
    public function get_email_id_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_email_id();
    }

    /**
     * get_attachment_path_by_id method is stand for get the value ofattachment_path By
     * id.
     *
     * @var varchar attachment_path
     */
    public function get_attachment_path_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_attachment_path();
    }


}
