<?php

class Application_Model_EmailLog extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_email_log';

    private $_id = null;

    private $_log_email_to = null;

    private $_log_email_cc = null;

    private $_log_email_bcc = null;

    private $_log_email_from = null;

    private $_log_email_from_name = null;

    private $_log_subject = null;

    private $_log_body = null;

    private $_log_status = null;

    private $_log_send = null;

    private $_log_updated_by = null;

    private $_log_updated_date = null;

    private $_log_created_by = null;

    private $_log_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get log_email_to method is stand for get the value of log_email_to.
     *
     * @var text log_email_to
     */
    public function get_log_email_to()
    {
        return $this->_log_email_to;
    }

    /**
     * set log_email_to method is stand for set the value of log_email_to.
     *
     * @var text log_email_to
     */
    public function set_log_email_to($value)
    {
        $this->_log_email_to = $value;
    }

    /**
     * get log_email_cc method is stand for get the value of log_email_cc.
     *
     * @var text log_email_cc
     */
    public function get_log_email_cc()
    {
        return $this->_log_email_cc;
    }

    /**
     * set log_email_cc method is stand for set the value of log_email_cc.
     *
     * @var text log_email_cc
     */
    public function set_log_email_cc($value)
    {
        $this->_log_email_cc = $value;
    }

    /**
     * get log_email_bcc method is stand for get the value of log_email_bcc.
     *
     * @var text log_email_bcc
     */
    public function get_log_email_bcc()
    {
        return $this->_log_email_bcc;
    }

    /**
     * set log_email_bcc method is stand for set the value of log_email_bcc.
     *
     * @var text log_email_bcc
     */
    public function set_log_email_bcc($value)
    {
        $this->_log_email_bcc = $value;
    }

    /**
     * get log_email_from method is stand for get the value of log_email_from.
     *
     * @var varchar log_email_from
     */
    public function get_log_email_from()
    {
        return $this->_log_email_from;
    }

    /**
     * set log_email_from method is stand for set the value of log_email_from.
     *
     * @var varchar log_email_from
     */
    public function set_log_email_from($value)
    {
        $this->_log_email_from = $value;
    }

    /**
     * get log_email_from_name method is stand for get the value of
     * log_email_from_name.
     *
     * @var varchar log_email_from_name
     */
    public function get_log_email_from_name()
    {
        return $this->_log_email_from_name;
    }

    /**
     * set log_email_from_name method is stand for set the value of
     * log_email_from_name.
     *
     * @var varchar log_email_from_name
     */
    public function set_log_email_from_name($value)
    {
        $this->_log_email_from_name = $value;
    }

    /**
     * get log_subject method is stand for get the value of log_subject.
     *
     * @var varchar log_subject
     */
    public function get_log_subject()
    {
        return $this->_log_subject;
    }

    /**
     * set log_subject method is stand for set the value of log_subject.
     *
     * @var varchar log_subject
     */
    public function set_log_subject($value)
    {
        $this->_log_subject = $value;
    }

    /**
     * get log_body method is stand for get the value of log_body.
     *
     * @var text log_body
     */
    public function get_log_body()
    {
        return $this->_log_body;
    }

    /**
     * set log_body method is stand for set the value of log_body.
     *
     * @var text log_body
     */
    public function set_log_body($value)
    {
        $this->_log_body = $value;
    }

    /**
     * get log_status method is stand for get the value of log_status.
     *
     * @var varchar log_status
     */
    public function get_log_status()
    {
        return $this->_log_status;
    }

    /**
     * set log_status method is stand for set the value of log_status.
     *
     * @var varchar log_status
     */
    public function set_log_status($value)
    {
        $this->_log_status = $value;
    }

    /**
     * get log_send method is stand for get the value of log_send.
     *
     * @var datetime log_send
     */
    public function get_log_send()
    {
        return $this->_log_send;
    }

    /**
     * set log_send method is stand for set the value of log_send.
     *
     * @var datetime log_send
     */
    public function set_log_send($value)
    {
        $this->_log_send = $value;
    }

    /**
     * get log_updated_by method is stand for get the value of log_updated_by.
     *
     * @var int log_updated_by
     */
    public function get_log_updated_by()
    {
        return (int) $this->_log_updated_by;
    }

    /**
     * set log_updated_by method is stand for set the value of log_updated_by.
     *
     * @var int log_updated_by
     */
    public function set_log_updated_by($value)
    {
        $this->_log_updated_by = (int) $value;
    }

    /**
     * get log_updated_date method is stand for get the value of log_updated_date.
     *
     * @var timestamp log_updated_date
     */
    public function get_log_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_log_updated_date));
    }

    /**
     * set log_updated_date method is stand for set the value of log_updated_date.
     *
     * @var timestamp log_updated_date
     */
    public function set_log_updated_date($value)
    {
        $this->_log_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get log_created_by method is stand for get the value of log_created_by.
     *
     * @var int log_created_by
     */
    public function get_log_created_by()
    {
        return (int) $this->_log_created_by;
    }

    /**
     * set log_created_by method is stand for set the value of log_created_by.
     *
     * @var int log_created_by
     */
    public function set_log_created_by($value)
    {
        $this->_log_created_by = (int) $value;
    }

    /**
     * get log_created_date method is stand for get the value of log_created_date.
     *
     * @var timestamp log_created_date
     */
    public function get_log_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_log_created_date));
    }

    /**
     * set log_created_date method is stand for set the value of log_created_date.
     *
     * @var timestamp log_created_date
     */
    public function set_log_created_date($value)
    {
        $this->_log_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_email_log by set id thru constructor.
     *
     * @var int id
     * @var text log_email_to
     * @var text log_email_cc
     * @var text log_email_bcc
     * @var varchar log_email_from
     * @var varchar log_email_from_name
     * @var varchar log_subject
     * @var text log_body
     * @var varchar log_status
     * @var datetime log_send
     * @var int log_updated_by
     * @var timestamp log_updated_date
     * @var int log_created_by
     * @var timestamp log_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_log_email_to($row->log_email_to);
          $this->set_log_email_cc($row->log_email_cc);
          $this->set_log_email_bcc($row->log_email_bcc);
          $this->set_log_email_from($row->log_email_from);
          $this->set_log_email_from_name($row->log_email_from_name);
          $this->set_log_subject($row->log_subject);
          $this->set_log_body($row->log_body);
          $this->set_log_status($row->log_status);
          $this->set_log_send($row->log_send);
          $this->set_log_updated_by($row->log_updated_by);
          $this->set_log_updated_date($row->log_updated_date);
          $this->set_log_created_by($row->log_created_by);
          $this->set_log_created_date($row->log_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var text log_email_to
     * @var text log_email_cc
     * @var text log_email_bcc
     * @var varchar log_email_from
     * @var varchar log_email_from_name
     * @var varchar log_subject
     * @var text log_body
     * @var varchar log_status
     * @var datetime log_send
     * @var int log_updated_by
     * @var int log_created_by
     */
    public function save()
    {
        $data = array(
          "log_email_to" => $this->get_log_email_to(),
          "log_email_cc" => $this->get_log_email_cc(),
          "log_email_bcc" => $this->get_log_email_bcc(),
          "log_email_from" => $this->get_log_email_from(),
          "log_email_from_name" => $this->get_log_email_from_name(),
          "log_subject" => $this->get_log_subject(),
          "log_body" => $this->get_log_body(),
          "log_status" => $this->get_log_status(),
          "log_send" => $this->get_log_send(),
          "log_updated_by" => $this->get_log_updated_by(),
          "log_created_by" => $this->get_log_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_email_log by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_log_email_to_by_id method is stand for get the value oflog_email_to By id.
     *
     * @var text log_email_to
     */
    public function get_log_email_to_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_log_email_to();
    }

    /**
     * get_log_email_cc_by_id method is stand for get the value oflog_email_cc By id.
     *
     * @var text log_email_cc
     */
    public function get_log_email_cc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_log_email_cc();
    }

    /**
     * get_log_email_bcc_by_id method is stand for get the value oflog_email_bcc By id.
     *
     * @var text log_email_bcc
     */
    public function get_log_email_bcc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_log_email_bcc();
    }

    /**
     * get_log_email_from_by_id method is stand for get the value oflog_email_from By
     * id.
     *
     * @var varchar log_email_from
     */
    public function get_log_email_from_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_log_email_from();
    }

    /**
     * get_log_email_from_name_by_id method is stand for get the value
     * oflog_email_from_name By id.
     *
     * @var varchar log_email_from_name
     */
    public function get_log_email_from_name_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_log_email_from_name();
    }

    /**
     * get_log_subject_by_id method is stand for get the value oflog_subject By id.
     *
     * @var varchar log_subject
     */
    public function get_log_subject_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_log_subject();
    }

    /**
     * get_log_body_by_id method is stand for get the value oflog_body By id.
     *
     * @var text log_body
     */
    public function get_log_body_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_log_body();
    }

    /**
     * get_log_status_by_id method is stand for get the value oflog_status By id.
     *
     * @var varchar log_status
     */
    public function get_log_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_log_status();
    }

    /**
     * get_log_send_by_id method is stand for get the value oflog_send By id.
     *
     * @var datetime log_send
     */
    public function get_log_send_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_log_send();
    }

    /**
     * get_log_updated_by_by_id method is stand for get the value oflog_updated_by By
     * id.
     *
     * @var int log_updated_by
     */
    public function get_log_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_log_updated_by();
    }

    /**
     * get_log_updated_date_by_id method is stand for get the value oflog_updated_date
     * By id.
     *
     * @var timestamp log_updated_date
     */
    public function get_log_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_log_updated_date()));
    }

    /**
     * get_log_created_by_by_id method is stand for get the value oflog_created_by By
     * id.
     *
     * @var int log_created_by
     */
    public function get_log_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_log_created_by();
    }

    /**
     * get_log_created_date_by_id method is stand for get the value oflog_created_date
     * By id.
     *
     * @var timestamp log_created_date
     */
    public function get_log_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_log_created_date()));
    }


}
