<?php

class Application_Model_EmailLogLogic extends Application_Model_EmailLog
{

    public function fetchDataTableSelect() 
    {
        $columns = array('log_email_to', 'log_email_from', 'log_subject', 'log_send');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_EmailLog(-1)), $columns);
        $where = $obj_data->get_where();
        $where->order('id desc');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        foreach($rows as $row)
        {
            $results[$i] = array($row->log_email_from, $row->log_email_to, $row->log_subject, Application_Model_Util_Date::convertToDisplay($row->log_send));
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function initiateBulkEmail()
    {
        $user = new Application_Model_UserLogic(-1);
        $this->removeInitiatedEmail($user->getLoggedInUserId());
        $this->set_id(-1);
        $this->set_log_email_from(Application_Model_Cache_Config::getConfig("DEFAULT_SENDER_MAIL_ADDRESS"));
        $this->set_log_email_from_name(Application_Model_Cache_Config::getConfig("DEFAULT_SENDER_MAIL_NAME"));
        $this->set_log_status('Initiate');
        $this->set_log_email_to('');
        $this->set_log_email_cc('');
        $this->set_log_email_bcc('');
        $this->set_log_subject('');
        $this->set_log_body('');
        $this->set_log_created_by($user->getLoggedInUserId());
        $this->save();
        return $this->getAdapter()->lastInsertId();
    }
    
    public function removeInitiatedEmail($uid)
    {
        $where = $this->select()->where('log_status = ?', 'Initiate')->where('log_created_by = ?', $uid);
        foreach($this->fetchAll($where) as $row) {
            $obj_attach = new Application_Model_EmailAttachment(-1);
            $where = $obj_attach->select()->where("email_id = ?", $row->id);
            foreach ($obj_attach->fetchAll($where) as $res) {
                $obj_attach->set_id($res->id);
                $obj_attach->remove();
            }
            $this->set_id($row->id);
            $this->remove();
        }
    }

}

