<?php

class Application_Model_EmailSchedule extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_email_schedule';

    private $_id = null;

    private $_email_to = null;

    private $_email_cc = null;

    private $_email_bcc = null;

    private $_email_from = null;

    private $_email_from_name = null;

    private $_email_schedule = null;

    private $_email_subject = null;

    private $_email_body = null;

    private $_email_priority = null;

    private $_email_updated_by = null;

    private $_email_updated_date = null;

    private $_email_created_by = null;

    private $_email_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get email_to method is stand for get the value of email_to.
     *
     * @var text email_to
     */
    public function get_email_to()
    {
        return $this->_email_to;
    }

    /**
     * set email_to method is stand for set the value of email_to.
     *
     * @var text email_to
     */
    public function set_email_to($value)
    {
        $this->_email_to = $value;
    }

    /**
     * get email_cc method is stand for get the value of email_cc.
     *
     * @var text email_cc
     */
    public function get_email_cc()
    {
        return $this->_email_cc;
    }

    /**
     * set email_cc method is stand for set the value of email_cc.
     *
     * @var text email_cc
     */
    public function set_email_cc($value)
    {
        $this->_email_cc = $value;
    }

    /**
     * get email_bcc method is stand for get the value of email_bcc.
     *
     * @var text email_bcc
     */
    public function get_email_bcc()
    {
        return $this->_email_bcc;
    }

    /**
     * set email_bcc method is stand for set the value of email_bcc.
     *
     * @var text email_bcc
     */
    public function set_email_bcc($value)
    {
        $this->_email_bcc = $value;
    }

    /**
     * get email_from method is stand for get the value of email_from.
     *
     * @var varchar email_from
     */
    public function get_email_from()
    {
        return $this->_email_from;
    }

    /**
     * set email_from method is stand for set the value of email_from.
     *
     * @var varchar email_from
     */
    public function set_email_from($value)
    {
        $this->_email_from = $value;
    }

    /**
     * get email_from_name method is stand for get the value of email_from_name.
     *
     * @var varchar email_from_name
     */
    public function get_email_from_name()
    {
        return $this->_email_from_name;
    }

    /**
     * set email_from_name method is stand for set the value of email_from_name.
     *
     * @var varchar email_from_name
     */
    public function set_email_from_name($value)
    {
        $this->_email_from_name = $value;
    }

    /**
     * get email_schedule method is stand for get the value of email_schedule.
     *
     * @var datetime email_schedule
     */
    public function get_email_schedule()
    {
        return $this->_email_schedule;
    }

    /**
     * set email_schedule method is stand for set the value of email_schedule.
     *
     * @var datetime email_schedule
     */
    public function set_email_schedule($value)
    {
        $this->_email_schedule = $value;
    }

    /**
     * get email_subject method is stand for get the value of email_subject.
     *
     * @var varchar email_subject
     */
    public function get_email_subject()
    {
        return $this->_email_subject;
    }

    /**
     * set email_subject method is stand for set the value of email_subject.
     *
     * @var varchar email_subject
     */
    public function set_email_subject($value)
    {
        $this->_email_subject = $value;
    }

    /**
     * get email_body method is stand for get the value of email_body.
     *
     * @var text email_body
     */
    public function get_email_body()
    {
        return $this->_email_body;
    }

    /**
     * set email_body method is stand for set the value of email_body.
     *
     * @var text email_body
     */
    public function set_email_body($value)
    {
        $this->_email_body = $value;
    }

    /**
     * get email_priority method is stand for get the value of email_priority.
     *
     * @var tinyint email_priority
     */
    public function get_email_priority()
    {
        return $this->_email_priority;
    }

    /**
     * set email_priority method is stand for set the value of email_priority.
     *
     * @var tinyint email_priority
     */
    public function set_email_priority($value)
    {
        $this->_email_priority = $value;
    }

    /**
     * get email_updated_by method is stand for get the value of email_updated_by.
     *
     * @var int email_updated_by
     */
    public function get_email_updated_by()
    {
        return (int) $this->_email_updated_by;
    }

    /**
     * set email_updated_by method is stand for set the value of email_updated_by.
     *
     * @var int email_updated_by
     */
    public function set_email_updated_by($value)
    {
        $this->_email_updated_by = (int) $value;
    }

    /**
     * get email_updated_date method is stand for get the value of email_updated_date.
     *
     * @var timestamp email_updated_date
     */
    public function get_email_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_email_updated_date));
    }

    /**
     * set email_updated_date method is stand for set the value of email_updated_date.
     *
     * @var timestamp email_updated_date
     */
    public function set_email_updated_date($value)
    {
        $this->_email_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get email_created_by method is stand for get the value of email_created_by.
     *
     * @var int email_created_by
     */
    public function get_email_created_by()
    {
        return (int) $this->_email_created_by;
    }

    /**
     * set email_created_by method is stand for set the value of email_created_by.
     *
     * @var int email_created_by
     */
    public function set_email_created_by($value)
    {
        $this->_email_created_by = (int) $value;
    }

    /**
     * get email_created_date method is stand for get the value of email_created_date.
     *
     * @var timestamp email_created_date
     */
    public function get_email_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_email_created_date));
    }

    /**
     * set email_created_date method is stand for set the value of email_created_date.
     *
     * @var timestamp email_created_date
     */
    public function set_email_created_date($value)
    {
        $this->_email_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_email_schedule by set id thru constructor.
     *
     * @var int id
     * @var text email_to
     * @var text email_cc
     * @var text email_bcc
     * @var varchar email_from
     * @var varchar email_from_name
     * @var datetime email_schedule
     * @var varchar email_subject
     * @var text email_body
     * @var tinyint email_priority
     * @var int email_updated_by
     * @var timestamp email_updated_date
     * @var int email_created_by
     * @var timestamp email_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_email_to($row->email_to);
          $this->set_email_cc($row->email_cc);
          $this->set_email_bcc($row->email_bcc);
          $this->set_email_from($row->email_from);
          $this->set_email_from_name($row->email_from_name);
          $this->set_email_schedule($row->email_schedule);
          $this->set_email_subject($row->email_subject);
          $this->set_email_body($row->email_body);
          $this->set_email_priority($row->email_priority);
          $this->set_email_updated_by($row->email_updated_by);
          $this->set_email_updated_date($row->email_updated_date);
          $this->set_email_created_by($row->email_created_by);
          $this->set_email_created_date($row->email_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var text email_to
     * @var text email_cc
     * @var text email_bcc
     * @var varchar email_from
     * @var varchar email_from_name
     * @var datetime email_schedule
     * @var varchar email_subject
     * @var text email_body
     * @var tinyint email_priority
     * @var int email_updated_by
     * @var int email_created_by
     */
    public function save()
    {
        $data = array(
          "email_to" => $this->get_email_to(),
          "email_cc" => $this->get_email_cc(),
          "email_bcc" => $this->get_email_bcc(),
          "email_from" => $this->get_email_from(),
          "email_from_name" => $this->get_email_from_name(),
          "email_schedule" => $this->get_email_schedule(),
          "email_subject" => $this->get_email_subject(),
          "email_body" => $this->get_email_body(),
          "email_priority" => $this->get_email_priority(),
          "email_updated_by" => $this->get_email_updated_by(),
          "email_created_by" => $this->get_email_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_email_schedule by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_email_to_by_id method is stand for get the value ofemail_to By id.
     *
     * @var text email_to
     */
    public function get_email_to_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_email_to();
    }

    /**
     * get_email_cc_by_id method is stand for get the value ofemail_cc By id.
     *
     * @var text email_cc
     */
    public function get_email_cc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_email_cc();
    }

    /**
     * get_email_bcc_by_id method is stand for get the value ofemail_bcc By id.
     *
     * @var text email_bcc
     */
    public function get_email_bcc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_email_bcc();
    }

    /**
     * get_email_from_by_id method is stand for get the value ofemail_from By id.
     *
     * @var varchar email_from
     */
    public function get_email_from_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_email_from();
    }

    /**
     * get_email_from_name_by_id method is stand for get the value ofemail_from_name By
     * id.
     *
     * @var varchar email_from_name
     */
    public function get_email_from_name_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_email_from_name();
    }

    /**
     * get_email_schedule_by_id method is stand for get the value ofemail_schedule By
     * id.
     *
     * @var datetime email_schedule
     */
    public function get_email_schedule_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_email_schedule();
    }

    /**
     * get_email_subject_by_id method is stand for get the value ofemail_subject By id.
     *
     * @var varchar email_subject
     */
    public function get_email_subject_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_email_subject();
    }

    /**
     * get_email_body_by_id method is stand for get the value ofemail_body By id.
     *
     * @var text email_body
     */
    public function get_email_body_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_email_body();
    }

    /**
     * get_email_priority_by_id method is stand for get the value ofemail_priority By
     * id.
     *
     * @var tinyint email_priority
     */
    public function get_email_priority_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_email_priority();
    }

    /**
     * get_email_updated_by_by_id method is stand for get the value ofemail_updated_by
     * By id.
     *
     * @var int email_updated_by
     */
    public function get_email_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_email_updated_by();
    }

    /**
     * get_email_updated_date_by_id method is stand for get the value
     * ofemail_updated_date By id.
     *
     * @var timestamp email_updated_date
     */
    public function get_email_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_email_updated_date()));
    }

    /**
     * get_email_created_by_by_id method is stand for get the value ofemail_created_by
     * By id.
     *
     * @var int email_created_by
     */
    public function get_email_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_email_created_by();
    }

    /**
     * get_email_created_date_by_id method is stand for get the value
     * ofemail_created_date By id.
     *
     * @var timestamp email_created_date
     */
    public function get_email_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_email_created_date()));
    }


}
