<?php

class Application_Model_EmailScheduleLogic extends Application_Model_EmailSchedule
{
    
    public function fetchDataTableSelect()
    {
        $columns = array('email_to', 'email_schedule', 'email_subject');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_EmailScheduleLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Email:Schedule:Manage")) {
                $action = '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"email", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Perils:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"email", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->email_to, date('d-M-Y h:i:s A', strtotime($row->email_schedule)), $row->email_subject, $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getCronEmails()
    {
        $where = $this->select()->where('email_schedule >= ?', date('Y-m-d H:i:s', strtotime(Application_Model_Cache_Config::getConfig("DEFAULT_EMAIL_SCHEDULE_CRON"), strtotime(date('Y-m-d H:i:s')))))
               ->where('email_schedule <= ?', date('Y-m-d H:i:s'))->where('email_priority >= ?', 0);
        return $this->fetchAll($where);
    }


}

