<?php

class Application_Model_ErrorLog extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_error_log';

    private $_id = null;

    private $_error_message = null;

    private $_error_exception = null;

    private $_error_parameters = null;

    private $_error_url = null;

    private $_error_status = null;

    private $_error_updated_by = null;

    private $_error_updated_date = null;

    private $_error_created_by = null;

    private $_error_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get error_message method is stand for get the value of error_message.
     *
     * @var varchar error_message
     */
    public function get_error_message()
    {
        return $this->_error_message;
    }

    /**
     * set error_message method is stand for set the value of error_message.
     *
     * @var varchar error_message
     */
    public function set_error_message($value)
    {
        $this->_error_message = $value;
    }

    /**
     * get error_exception method is stand for get the value of error_exception.
     *
     * @var text error_exception
     */
    public function get_error_exception()
    {
        return $this->_error_exception;
    }

    /**
     * set error_exception method is stand for set the value of error_exception.
     *
     * @var text error_exception
     */
    public function set_error_exception($value)
    {
        $this->_error_exception = $value;
    }

    /**
     * get error_parameters method is stand for get the value of error_parameters.
     *
     * @var text error_parameters
     */
    public function get_error_parameters()
    {
        return $this->_error_parameters;
    }

    /**
     * set error_parameters method is stand for set the value of error_parameters.
     *
     * @var text error_parameters
     */
    public function set_error_parameters($value)
    {
        $this->_error_parameters = $value;
    }

    /**
     * get error_url method is stand for get the value of error_url.
     *
     * @var varchar error_url
     */
    public function get_error_url()
    {
        return $this->_error_url;
    }

    /**
     * set error_url method is stand for set the value of error_url.
     *
     * @var varchar error_url
     */
    public function set_error_url($value)
    {
        $this->_error_url = $value;
    }

    /**
     * get error_status method is stand for get the value of error_status.
     *
     * @var varchar error_status
     */
    public function get_error_status()
    {
        return $this->_error_status;
    }

    /**
     * set error_status method is stand for set the value of error_status.
     *
     * @var varchar error_status
     */
    public function set_error_status($value)
    {
        $this->_error_status = $value;
    }

    /**
     * get error_updated_by method is stand for get the value of error_updated_by.
     *
     * @var int error_updated_by
     */
    public function get_error_updated_by()
    {
        return (int) $this->_error_updated_by;
    }

    /**
     * set error_updated_by method is stand for set the value of error_updated_by.
     *
     * @var int error_updated_by
     */
    public function set_error_updated_by($value)
    {
        $this->_error_updated_by = (int) $value;
    }

    /**
     * get error_updated_date method is stand for get the value of error_updated_date.
     *
     * @var timestamp error_updated_date
     */
    public function get_error_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_error_updated_date));
    }

    /**
     * set error_updated_date method is stand for set the value of error_updated_date.
     *
     * @var timestamp error_updated_date
     */
    public function set_error_updated_date($value)
    {
        $this->_error_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get error_created_by method is stand for get the value of error_created_by.
     *
     * @var int error_created_by
     */
    public function get_error_created_by()
    {
        return (int) $this->_error_created_by;
    }

    /**
     * set error_created_by method is stand for set the value of error_created_by.
     *
     * @var int error_created_by
     */
    public function set_error_created_by($value)
    {
        $this->_error_created_by = (int) $value;
    }

    /**
     * get error_created_date method is stand for get the value of error_created_date.
     *
     * @var timestamp error_created_date
     */
    public function get_error_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_error_created_date));
    }

    /**
     * set error_created_date method is stand for set the value of error_created_date.
     *
     * @var timestamp error_created_date
     */
    public function set_error_created_date($value)
    {
        $this->_error_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_error_log by set id thru constructor.
     *
     * @var int id
     * @var varchar error_message
     * @var text error_exception
     * @var text error_parameters
     * @var varchar error_url
     * @var varchar error_status
     * @var int error_updated_by
     * @var timestamp error_updated_date
     * @var int error_created_by
     * @var timestamp error_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_error_message($row->error_message);
          $this->set_error_exception($row->error_exception);
          $this->set_error_parameters($row->error_parameters);
          $this->set_error_url($row->error_url);
          $this->set_error_status($row->error_status);
          $this->set_error_updated_by($row->error_updated_by);
          $this->set_error_updated_date($row->error_updated_date);
          $this->set_error_created_by($row->error_created_by);
          $this->set_error_created_date($row->error_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar error_message
     * @var text error_exception
     * @var text error_parameters
     * @var varchar error_url
     * @var varchar error_status
     * @var int error_updated_by
     * @var int error_created_by
     */
    public function save()
    {
        $data = array(
          "error_message" => $this->get_error_message(),
          "error_exception" => $this->get_error_exception(),
          "error_parameters" => $this->get_error_parameters(),
          "error_url" => $this->get_error_url(),
          "error_status" => $this->get_error_status(),
          "error_updated_by" => $this->get_error_updated_by(),
          "error_created_by" => $this->get_error_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_error_log by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_error_message_by_id method is stand for get the value oferror_message By id.
     *
     * @var varchar error_message
     */
    public function get_error_message_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_error_message();
    }

    /**
     * get_error_exception_by_id method is stand for get the value oferror_exception By
     * id.
     *
     * @var text error_exception
     */
    public function get_error_exception_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_error_exception();
    }

    /**
     * get_error_parameters_by_id method is stand for get the value oferror_parameters
     * By id.
     *
     * @var text error_parameters
     */
    public function get_error_parameters_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_error_parameters();
    }

    /**
     * get_error_url_by_id method is stand for get the value oferror_url By id.
     *
     * @var varchar error_url
     */
    public function get_error_url_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_error_url();
    }

    /**
     * get_error_status_by_id method is stand for get the value oferror_status By id.
     *
     * @var varchar error_status
     */
    public function get_error_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_error_status();
    }

    /**
     * get_error_updated_by_by_id method is stand for get the value oferror_updated_by
     * By id.
     *
     * @var int error_updated_by
     */
    public function get_error_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_error_updated_by();
    }

    /**
     * get_error_updated_date_by_id method is stand for get the value
     * oferror_updated_date By id.
     *
     * @var timestamp error_updated_date
     */
    public function get_error_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_error_updated_date()));
    }

    /**
     * get_error_created_by_by_id method is stand for get the value oferror_created_by
     * By id.
     *
     * @var int error_created_by
     */
    public function get_error_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_error_created_by();
    }

    /**
     * get_error_created_date_by_id method is stand for get the value
     * oferror_created_date By id.
     *
     * @var timestamp error_created_date
     */
    public function get_error_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_error_created_date()));
    }


}
