<?php

class Application_Model_ErrorLogLogic extends Application_Model_ErrorLog
{
    
    public function fetchDataTableSelect() 
    {
        $columns = array('error_message', 'error_url', 'error_created_date');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_ErrorLogLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->order('id desc');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        foreach($rows as $row)
        {
            $results[$i] = array($row->error_message, $row->error_url, Application_Model_Util_Date::convertToDisplay($row->error_created_date));
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public static function insertLog($message, $exception, $parameters, $url)
    {
        if(Application_Model_Cache_Config::getConfig('MONITOR_ERROR_LOG') == 'true') {
            $user = new Application_Model_UserLogic(-1);
            $obj_err = new Application_Model_ErrorLogLogic(-1);
            $obj_err->set_error_url($url);
            $obj_err->set_error_message($message);
            $obj_err->set_error_exception("<p><b>Message:</b> ".$exception->getMessage()."</p><h3>Stack trace:</h3><pre>".$exception->getTraceAsString()."</pre>");
            $obj_err->set_error_parameters(var_export($parameters, true));
            $obj_err->set_error_status('Active');
            $obj_err->set_error_created_by(($user->getLoggedInUserId() != null && $user->getLoggedInUserId() != '') ? $user->getLoggedInUserId() : 0);
            $obj_err->set_error_updated_by(($user->getLoggedInUserId() != null && $user->getLoggedInUserId() != '') ? $user->getLoggedInUserId() : 0);
            $obj_err->save();
        }
    }


}

