<?php

class Application_Model_Events extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_events';

    private $_id = null;

    private $_event_title = null;

    private $_event_intro_text = null;

    private $_event_desc = null;

    private $_event_start = null;

    private $_event_end = null;

    private $_event_url = null;

    private $_event_color = null;

    private $_event_status = null;

    private $_event_updated_by = null;

    private $_event_updated_date = null;

    private $_event_created_by = null;

    private $_event_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get event_title method is stand for get the value of event_title.
     *
     * @var varchar event_title
     */
    public function get_event_title()
    {
        return $this->_event_title;
    }

    /**
     * set event_title method is stand for set the value of event_title.
     *
     * @var varchar event_title
     */
    public function set_event_title($value)
    {
        $this->_event_title = $value;
    }

    /**
     * get event_intro_text method is stand for get the value of event_intro_text.
     *
     * @var varchar event_intro_text
     */
    public function get_event_intro_text()
    {
        return $this->_event_intro_text;
    }

    /**
     * set event_intro_text method is stand for set the value of event_intro_text.
     *
     * @var varchar event_intro_text
     */
    public function set_event_intro_text($value)
    {
        $this->_event_intro_text = $value;
    }

    /**
     * get event_desc method is stand for get the value of event_desc.
     *
     * @var text event_desc
     */
    public function get_event_desc()
    {
        return $this->_event_desc;
    }

    /**
     * set event_desc method is stand for set the value of event_desc.
     *
     * @var text event_desc
     */
    public function set_event_desc($value)
    {
        $this->_event_desc = $value;
    }

    /**
     * get event_start method is stand for get the value of event_start.
     *
     * @var datetime event_start
     */
    public function get_event_start()
    {
        return $this->_event_start;
    }

    /**
     * set event_start method is stand for set the value of event_start.
     *
     * @var datetime event_start
     */
    public function set_event_start($value)
    {
        $this->_event_start = $value;
    }

    /**
     * get event_end method is stand for get the value of event_end.
     *
     * @var datetime event_end
     */
    public function get_event_end()
    {
        return $this->_event_end;
    }

    /**
     * set event_end method is stand for set the value of event_end.
     *
     * @var datetime event_end
     */
    public function set_event_end($value)
    {
        $this->_event_end = $value;
    }

    /**
     * get event_url method is stand for get the value of event_url.
     *
     * @var varchar event_url
     */
    public function get_event_url()
    {
        return $this->_event_url;
    }

    /**
     * set event_url method is stand for set the value of event_url.
     *
     * @var varchar event_url
     */
    public function set_event_url($value)
    {
        $this->_event_url = $value;
    }

    /**
     * get event_color method is stand for get the value of event_color.
     *
     * @var varchar event_color
     */
    public function get_event_color()
    {
        return $this->_event_color;
    }

    /**
     * set event_color method is stand for set the value of event_color.
     *
     * @var varchar event_color
     */
    public function set_event_color($value)
    {
        $this->_event_color = $value;
    }

    /**
     * get event_status method is stand for get the value of event_status.
     *
     * @var varchar event_status
     */
    public function get_event_status()
    {
        return $this->_event_status;
    }

    /**
     * set event_status method is stand for set the value of event_status.
     *
     * @var varchar event_status
     */
    public function set_event_status($value)
    {
        $this->_event_status = $value;
    }

    /**
     * get event_updated_by method is stand for get the value of event_updated_by.
     *
     * @var int event_updated_by
     */
    public function get_event_updated_by()
    {
        return (int) $this->_event_updated_by;
    }

    /**
     * set event_updated_by method is stand for set the value of event_updated_by.
     *
     * @var int event_updated_by
     */
    public function set_event_updated_by($value)
    {
        $this->_event_updated_by = (int) $value;
    }

    /**
     * get event_updated_date method is stand for get the value of event_updated_date.
     *
     * @var timestamp event_updated_date
     */
    public function get_event_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_event_updated_date));
    }

    /**
     * set event_updated_date method is stand for set the value of event_updated_date.
     *
     * @var timestamp event_updated_date
     */
    public function set_event_updated_date($value)
    {
        $this->_event_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get event_created_by method is stand for get the value of event_created_by.
     *
     * @var int event_created_by
     */
    public function get_event_created_by()
    {
        return (int) $this->_event_created_by;
    }

    /**
     * set event_created_by method is stand for set the value of event_created_by.
     *
     * @var int event_created_by
     */
    public function set_event_created_by($value)
    {
        $this->_event_created_by = (int) $value;
    }

    /**
     * get event_created_date method is stand for get the value of event_created_date.
     *
     * @var timestamp event_created_date
     */
    public function get_event_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_event_created_date));
    }

    /**
     * set event_created_date method is stand for set the value of event_created_date.
     *
     * @var timestamp event_created_date
     */
    public function set_event_created_date($value)
    {
        $this->_event_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_events by set id thru constructor.
     *
     * @var int id
     * @var varchar event_title
     * @var varchar event_intro_text
     * @var text event_desc
     * @var datetime event_start
     * @var datetime event_end
     * @var varchar event_url
     * @var varchar event_color
     * @var int event_site
     * @var varchar event_status
     * @var int event_updated_by
     * @var timestamp event_updated_date
     * @var int event_created_by
     * @var timestamp event_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_event_title($row->event_title);
          $this->set_event_intro_text($row->event_intro_text);
          $this->set_event_desc($row->event_desc);
          $this->set_event_start($row->event_start);
          $this->set_event_end($row->event_end);
          $this->set_event_url($row->event_url);
          $this->set_event_color($row->event_color);
          $this->set_event_status($row->event_status);
          $this->set_event_updated_by($row->event_updated_by);
          $this->set_event_updated_date($row->event_updated_date);
          $this->set_event_created_by($row->event_created_by);
          $this->set_event_created_date($row->event_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar event_title
     * @var varchar event_intro_text
     * @var text event_desc
     * @var datetime event_start
     * @var datetime event_end
     * @var varchar event_url
     * @var varchar event_color
     * @var int event_site
     * @var varchar event_status
     * @var int event_updated_by
     * @var int event_created_by
     */
    public function save()
    {
        $data = array(
          "event_title" => $this->get_event_title(),
          "event_intro_text" => $this->get_event_intro_text(),
          "event_desc" => $this->get_event_desc(),
          "event_start" => $this->get_event_start(),
          "event_end" => $this->get_event_end(),
          "event_url" => $this->get_event_url(),
          "event_color" => $this->get_event_color(),
          "event_status" => $this->get_event_status(),
          "event_updated_by" => $this->get_event_updated_by(),
          "event_created_by" => $this->get_event_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_events by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_event_title_by_id method is stand for get the value ofevent_title By id.
     *
     * @var varchar event_title
     */
    public function get_event_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_event_title();
    }

    /**
     * get_event_intro_text_by_id method is stand for get the value ofevent_intro_text
     * By id.
     *
     * @var varchar event_intro_text
     */
    public function get_event_intro_text_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_event_intro_text();
    }

    /**
     * get_event_desc_by_id method is stand for get the value ofevent_desc By id.
     *
     * @var text event_desc
     */
    public function get_event_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_event_desc();
    }

    /**
     * get_event_start_by_id method is stand for get the value ofevent_start By id.
     *
     * @var datetime event_start
     */
    public function get_event_start_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_event_start();
    }

    /**
     * get_event_end_by_id method is stand for get the value ofevent_end By id.
     *
     * @var datetime event_end
     */
    public function get_event_end_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_event_end();
    }

    /**
     * get_event_url_by_id method is stand for get the value ofevent_url By id.
     *
     * @var varchar event_url
     */
    public function get_event_url_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_event_url();
    }

    /**
     * get_event_color_by_id method is stand for get the value ofevent_color By id.
     *
     * @var varchar event_color
     */
    public function get_event_color_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_event_color();
    }

    /**
     * get_event_status_by_id method is stand for get the value ofevent_status By id.
     *
     * @var varchar event_status
     */
    public function get_event_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_event_status();
    }

    /**
     * get_event_updated_by_by_id method is stand for get the value ofevent_updated_by
     * By id.
     *
     * @var int event_updated_by
     */
    public function get_event_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_event_updated_by();
    }

    /**
     * get_event_updated_date_by_id method is stand for get the value
     * ofevent_updated_date By id.
     *
     * @var timestamp event_updated_date
     */
    public function get_event_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_event_updated_date()));
    }

    /**
     * get_event_created_by_by_id method is stand for get the value ofevent_created_by
     * By id.
     *
     * @var int event_created_by
     */
    public function get_event_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_event_created_by();
    }

    /**
     * get_event_created_date_by_id method is stand for get the value
     * ofevent_created_date By id.
     *
     * @var timestamp event_created_date
     */
    public function get_event_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_event_created_date()));
    }


}
