<?php

class Application_Model_EventsLogic extends Application_Model_Events
{
    
    public function fetchOrdered($start = null, $end = null)
    {
        $where = $this->select()->where('event_status != ?', 'D')->order('event_title');
        if(null != $start) {
            $where->where('event_start >= ?', $start);
        }
        if(null != $end) {
            $where->where('event_end <= ?', $end);
        }
        return $this->fetchAll($where);
    }
    
    public function fetchLimitOrdered($limit = 10) {
        return $this->fetchAll($this->selectLimitOrdered($limit));
    }
    
    public function selectLimitOrdered($limit = 10) {
        $where = $this->select()->where('event_status = ?', 'A')->order('event_start');
        $where->orWhere('event_start >= ?', date('Y-m-d H:i:s'));
        $where->orWhere('event_end >= ?', date('Y-m-d H:i:s'));
        if(null != $limit) {
            $where->limit($limit);
        }
        return $where;
    }
    
    public function fetchDataTableSelect() 
    {
        $columns = array('event_title', 'event_start', 'event_end', 'event_status', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_EventsLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('event_status != ?', 'D');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Events:Edit")) {
                $action = '<a href="'.$url->url(array("controller"=>"events", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Events:Delete")) {
                $action .= '<a href="'.$url->url(array("controller"=>"events", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $status = Application_Model_Cache_Config::getConfig('STATUS_TYPE');
            $results[$i] = array($row->event_title, date('d-M-Y', strtotime($row->event_start)), date('d-M-Y', strtotime($row->event_end)), $status[$row->event_status], $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getEventByUrl($url) {
        $where = $this->select()->where('event_url = ?', $url)->where('event_status = ?', 'A');
        $row = $this->fetchRow($where);
        $this->set_id($row['id']);
        return $this->fetch();
    }
}

