<?php

class Application_Model_Google_Map
{
    
    const GOOGLE_MAP_URL_PREFIX = 'https://maps.googleapis.com/maps/api/';
    
    public function getJsonRequest($url='http://maps.googleapis.com/maps/api/geocode/json?latlng=28.7025901,77.1098974&sensor=true')
    {
        if(is_callable('curl_init')) {
            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_HEADER, false);
            curl_setopt($c, CURLOPT_TIMEOUT, 30);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            $results = Zend_Json::decode(curl_exec($c));
            curl_close($c);
            //Zend_Debug::dump($results);
            return $this->processJsonData($results);
        }
    }
    
    public function processJsonData($json)
    {
        $status = $json['status'];
        $data = null;
        if($status == 'OK') {
            $results = $json['results'][0];
            $data['status'] = $status;
            $data['address'] = $results['formatted_address'];
            $data['place_id'] = $results['place_id'];
            $data['type'] = $results['types'][0];
            $data['lat'] = $results['geometry']['location']['lat'];
            $data['lng'] = $results['geometry']['location']['lng'];
            foreach($results['address_components'] as $extra) {
                $data[$extra['types'][0]] = $extra['long_name'];
            }
        }
        return $data;
    }
    
    public function getMapDataByLatLan($lat, $lng)
    {
        $url = self::GOOGLE_MAP_URL_PREFIX.'geocode/json?latlng='.$lat.','.$lng.'&key='.Application_Model_Cache_Config::getConfig('GOOGLE_API_KEY');
        $cacheId = 'lat_lan_'.str_replace('.', '_', $lat).'_'.str_replace('.', '_', $lng);
        $cache = new Application_Model_Cache_Map();
        if(($result = $cache->getCache($cacheId)) == null) {
            $result = $cache->generateCache($cacheId, $this->getJsonRequest($url));
        }
        return $result;
    }
    
    public function getMapDataByAddress($address)
    {
        $url = self::GOOGLE_MAP_URL_PREFIX.'geocode/json?address='.  urlencode($address);//.'&key='.Application_Model_Cache_Config::getConfig('GOOGLE_API_KEY');
        $cacheId = 'address_'.  str_replace(' ', '-', $address);
        $cache = new Application_Model_Cache_Map();
        if(($result = $cache->getCache($cacheId)) == null) {
            $data = $this->getJsonRequest($url);
            if($data != null) {
                $result = $cache->generateCache($cacheId, $data);
            }else {
                $addr = explode('_', $address, 2);
                if(count($addr) == 2) {
                    $this->getMapDataByAddress($addr[1]);
                }
            }
        }
        return $result;
    }
    
    public function getMapDataByPlaceId($placeId)
    {
        $url = self::GOOGLE_MAP_URL_PREFIX.'geocode/json?place_id='.$placeId.'&key='.Application_Model_Cache_Config::getConfig('GOOGLE_API_KEY');
        $cacheId = 'place_'.$placeId;
        $cache = new Application_Model_Cache_Map();
        if(($result = $cache->getCache($cacheId)) == null) {
            $result = $cache->generateCache($cacheId, $this->getJsonRequest($url));
        }
        return $result;
    }
    
    
    
    
}

