<?php

class Application_Model_Homework extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_homework';

    private $_id = null;

    private $_hw_title = null;

    private $_hw_class = null;

    private $_hw_file = null;

    private $_hw_status = null;

    private $_hw_updated_by = null;

    private $_hw_updated_date = null;

    private $_hw_created_by = null;

    private $_hw_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get hw_title method is stand for get the value of hw_title.
     *
     * @var varchar hw_title
     */
    public function get_hw_title()
    {
        return $this->_hw_title;
    }

    /**
     * set hw_title method is stand for set the value of hw_title.
     *
     * @var varchar hw_title
     */
    public function set_hw_title($value)
    {
        $this->_hw_title = $value;
    }

    /**
     * get hw_class method is stand for get the value of hw_class.
     *
     * @var varchar hw_class
     */
    public function get_hw_class()
    {
        return $this->_hw_class;
    }

    /**
     * set hw_class method is stand for set the value of hw_class.
     *
     * @var varchar hw_class
     */
    public function set_hw_class($value)
    {
        $this->_hw_class = $value;
    }

    /**
     * get hw_file method is stand for get the value of hw_file.
     *
     * @var varchar hw_file
     */
    public function get_hw_file()
    {
        return $this->_hw_file;
    }

    /**
     * set hw_file method is stand for set the value of hw_file.
     *
     * @var varchar hw_file
     */
    public function set_hw_file($value)
    {
        $this->_hw_file = $value;
    }

    /**
     * get hw_status method is stand for get the value of hw_status.
     *
     * @var varchar hw_status
     */
    public function get_hw_status()
    {
        return $this->_hw_status;
    }

    /**
     * set hw_status method is stand for set the value of hw_status.
     *
     * @var varchar hw_status
     */
    public function set_hw_status($value)
    {
        $this->_hw_status = $value;
    }

    /**
     * get hw_updated_by method is stand for get the value of hw_updated_by.
     *
     * @var int hw_updated_by
     */
    public function get_hw_updated_by()
    {
        return (int) $this->_hw_updated_by;
    }

    /**
     * set hw_updated_by method is stand for set the value of hw_updated_by.
     *
     * @var int hw_updated_by
     */
    public function set_hw_updated_by($value)
    {
        $this->_hw_updated_by = (int) $value;
    }

    /**
     * get hw_updated_date method is stand for get the value of hw_updated_date.
     *
     * @var timestamp hw_updated_date
     */
    public function get_hw_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_hw_updated_date));
    }

    /**
     * set hw_updated_date method is stand for set the value of hw_updated_date.
     *
     * @var timestamp hw_updated_date
     */
    public function set_hw_updated_date($value)
    {
        $this->_hw_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get hw_created_by method is stand for get the value of hw_created_by.
     *
     * @var int hw_created_by
     */
    public function get_hw_created_by()
    {
        return (int) $this->_hw_created_by;
    }

    /**
     * set hw_created_by method is stand for set the value of hw_created_by.
     *
     * @var int hw_created_by
     */
    public function set_hw_created_by($value)
    {
        $this->_hw_created_by = (int) $value;
    }

    /**
     * get hw_created_date method is stand for get the value of hw_created_date.
     *
     * @var timestamp hw_created_date
     */
    public function get_hw_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_hw_created_date));
    }

    /**
     * set hw_created_date method is stand for set the value of hw_created_date.
     *
     * @var timestamp hw_created_date
     */
    public function set_hw_created_date($value)
    {
        $this->_hw_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_homework by set id thru constructor.
     *
     * @var int id
     * @var varchar hw_title
     * @var varchar hw_class
     * @var varchar hw_file
     * @var varchar hw_status
     * @var int hw_updated_by
     * @var timestamp hw_updated_date
     * @var int hw_created_by
     * @var timestamp hw_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_hw_title($row->hw_title);
          $this->set_hw_class($row->hw_class);
          $this->set_hw_file($row->hw_file);
          $this->set_hw_status($row->hw_status);
          $this->set_hw_updated_by($row->hw_updated_by);
          $this->set_hw_updated_date($row->hw_updated_date);
          $this->set_hw_created_by($row->hw_created_by);
          $this->set_hw_created_date($row->hw_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar hw_title
     * @var varchar hw_class
     * @var varchar hw_file
     * @var varchar hw_status
     * @var int hw_updated_by
     * @var int hw_created_by
     */
    public function save()
    {
        $data = array(
          "hw_title" => $this->get_hw_title(),
          "hw_class" => $this->get_hw_class(),
          "hw_file" => $this->get_hw_file(),
          "hw_status" => $this->get_hw_status(),
          "hw_updated_by" => $this->get_hw_updated_by(),
          "hw_created_by" => $this->get_hw_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_homework by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_hw_title_by_id method is stand for get the value ofhw_title By id.
     *
     * @var varchar hw_title
     */
    public function get_hw_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_hw_title();
    }

    /**
     * get_hw_class_by_id method is stand for get the value ofhw_class By id.
     *
     * @var varchar hw_class
     */
    public function get_hw_class_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_hw_class();
    }

    /**
     * get_hw_file_by_id method is stand for get the value ofhw_file By id.
     *
     * @var varchar hw_file
     */
    public function get_hw_file_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_hw_file();
    }

    /**
     * get_hw_status_by_id method is stand for get the value ofhw_status By id.
     *
     * @var varchar hw_status
     */
    public function get_hw_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_hw_status();
    }

    /**
     * get_hw_updated_by_by_id method is stand for get the value ofhw_updated_by By id.
     *
     * @var int hw_updated_by
     */
    public function get_hw_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_hw_updated_by();
    }

    /**
     * get_hw_updated_date_by_id method is stand for get the value ofhw_updated_date By
     * id.
     *
     * @var timestamp hw_updated_date
     */
    public function get_hw_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_hw_updated_date()));
    }

    /**
     * get_hw_created_by_by_id method is stand for get the value ofhw_created_by By id.
     *
     * @var int hw_created_by
     */
    public function get_hw_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_hw_created_by();
    }

    /**
     * get_hw_created_date_by_id method is stand for get the value ofhw_created_date By
     * id.
     *
     * @var timestamp hw_created_date
     */
    public function get_hw_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_hw_created_date()));
    }


}
