<?php

class Application_Model_HomeworkLogic extends Application_Model_Homework
{
    
    public function fetchOrdered()
    {
        return $this->fetchAll($this->select()->where('hw_status = ?', 'A')->order('hw_class'));
    }
    
    public function fetchSelect()
    {
        return $this->select()->where('hw_status = ?', 'A')->order('hw_class');
    }
    
    public function fetchDataTableSelect() 
    {
        $columns = array('hw_title', 'hw_class', 'hw_created_date', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_HomeworkLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('hw_status = ?', 'A');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $enc = new Application_Model_Util_Encrypt();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Homework:Edit")) {
                $action = '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"homework", "action"=>"edit", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Edit" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Homework:Edit")) {
                $action .= '<a href="#"><input type="button" value="Download" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Homework:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"homework", "action"=>"delete", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->hw_title, $row->hw_class, date('d-M-Y', strtotime($row->hw_created_date)), $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
}

