<?php

class Application_Model_Image extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_album_image';

    private $_id = null;

    private $_image_title = null;

    private $_image_desc = null;

    private $_image_path = null;

    private $_image_album = null;

    private $_image_status = null;

    private $_image_updated_by = null;

    private $_image_updated_date = null;

    private $_image_created_by = null;

    private $_image_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get image_title method is stand for get the value of image_title.
     *
     * @var varchar image_title
     */
    public function get_image_title()
    {
        return $this->_image_title;
    }

    /**
     * set image_title method is stand for set the value of image_title.
     *
     * @var varchar image_title
     */
    public function set_image_title($value)
    {
        $this->_image_title = $value;
    }

    /**
     * get image_desc method is stand for get the value of image_desc.
     *
     * @var varchar image_desc
     */
    public function get_image_desc()
    {
        return $this->_image_desc;
    }

    /**
     * set image_desc method is stand for set the value of image_desc.
     *
     * @var varchar image_desc
     */
    public function set_image_desc($value)
    {
        $this->_image_desc = $value;
    }

    /**
     * get image_path method is stand for get the value of image_path.
     *
     * @var varchar image_path
     */
    public function get_image_path()
    {
        return $this->_image_path;
    }

    /**
     * set image_path method is stand for set the value of image_path.
     *
     * @var varchar image_path
     */
    public function set_image_path($value)
    {
        $this->_image_path = $value;
    }

    /**
     * get image_album method is stand for get the value of image_album.
     *
     * @var int image_album
     */
    public function get_image_album()
    {
        return (int) $this->_image_album;
    }

    /**
     * set image_album method is stand for set the value of image_album.
     *
     * @var int image_album
     */
    public function set_image_album($value)
    {
        $this->_image_album = (int) $value;
    }

    /**
     * get image_status method is stand for get the value of image_status.
     *
     * @var varchar image_status
     */
    public function get_image_status()
    {
        return $this->_image_status;
    }

    /**
     * set image_status method is stand for set the value of image_status.
     *
     * @var varchar image_status
     */
    public function set_image_status($value)
    {
        $this->_image_status = $value;
    }

    /**
     * get image_updated_by method is stand for get the value of image_updated_by.
     *
     * @var int image_updated_by
     */
    public function get_image_updated_by()
    {
        return (int) $this->_image_updated_by;
    }

    /**
     * set image_updated_by method is stand for set the value of image_updated_by.
     *
     * @var int image_updated_by
     */
    public function set_image_updated_by($value)
    {
        $this->_image_updated_by = (int) $value;
    }

    /**
     * get image_updated_date method is stand for get the value of image_updated_date.
     *
     * @var timestamp image_updated_date
     */
    public function get_image_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_image_updated_date));
    }

    /**
     * set image_updated_date method is stand for set the value of image_updated_date.
     *
     * @var timestamp image_updated_date
     */
    public function set_image_updated_date($value)
    {
        $this->_image_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get image_created_by method is stand for get the value of image_created_by.
     *
     * @var int image_created_by
     */
    public function get_image_created_by()
    {
        return (int) $this->_image_created_by;
    }

    /**
     * set image_created_by method is stand for set the value of image_created_by.
     *
     * @var int image_created_by
     */
    public function set_image_created_by($value)
    {
        $this->_image_created_by = (int) $value;
    }

    /**
     * get image_created_date method is stand for get the value of image_created_date.
     *
     * @var timestamp image_created_date
     */
    public function get_image_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_image_created_date));
    }

    /**
     * set image_created_date method is stand for set the value of image_created_date.
     *
     * @var timestamp image_created_date
     */
    public function set_image_created_date($value)
    {
        $this->_image_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_album_image by set id thru constructor.
     *
     * @var int id
     * @var varchar image_title
     * @var varchar image_desc
     * @var varchar image_path
     * @var int image_album
     * @var varchar image_status
     * @var int image_updated_by
     * @var timestamp image_updated_date
     * @var int image_created_by
     * @var timestamp image_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_image_title($row->image_title);
          $this->set_image_desc($row->image_desc);
          $this->set_image_path($row->image_path);
          $this->set_image_album($row->image_album);
          $this->set_image_status($row->image_status);
          $this->set_image_updated_by($row->image_updated_by);
          $this->set_image_updated_date($row->image_updated_date);
          $this->set_image_created_by($row->image_created_by);
          $this->set_image_created_date($row->image_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar image_title
     * @var varchar image_desc
     * @var varchar image_path
     * @var int image_album
     * @var varchar image_status
     * @var int image_updated_by
     * @var int image_created_by
     */
    public function save()
    {
        $data = array(
          "image_title" => $this->get_image_title(),
          "image_desc" => $this->get_image_desc(),
          "image_path" => $this->get_image_path(),
          "image_album" => $this->get_image_album(),
          "image_status" => $this->get_image_status(),
          "image_updated_by" => $this->get_image_updated_by(),
          "image_created_by" => $this->get_image_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_album_image by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_image_title_by_id method is stand for get the value ofimage_title By id.
     *
     * @var varchar image_title
     */
    public function get_image_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_image_title();
    }

    /**
     * get_image_desc_by_id method is stand for get the value ofimage_desc By id.
     *
     * @var varchar image_desc
     */
    public function get_image_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_image_desc();
    }

    /**
     * get_image_path_by_id method is stand for get the value ofimage_path By id.
     *
     * @var varchar image_path
     */
    public function get_image_path_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_image_path();
    }

    /**
     * get_image_album_by_id method is stand for get the value ofimage_album By id.
     *
     * @var int image_album
     */
    public function get_image_album_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_image_album();
    }

    /**
     * get_image_status_by_id method is stand for get the value ofimage_status By id.
     *
     * @var varchar image_status
     */
    public function get_image_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_image_status();
    }

    /**
     * get_image_updated_by_by_id method is stand for get the value ofimage_updated_by
     * By id.
     *
     * @var int image_updated_by
     */
    public function get_image_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_image_updated_by();
    }

    /**
     * get_image_updated_date_by_id method is stand for get the value
     * ofimage_updated_date By id.
     *
     * @var timestamp image_updated_date
     */
    public function get_image_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_image_updated_date()));
    }

    /**
     * get_image_created_by_by_id method is stand for get the value ofimage_created_by
     * By id.
     *
     * @var int image_created_by
     */
    public function get_image_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_image_created_by();
    }

    /**
     * get_image_created_date_by_id method is stand for get the value
     * ofimage_created_date By id.
     *
     * @var timestamp image_created_date
     */
    public function get_image_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_image_created_date()));
    }


}
