<?php

class Application_Model_ImageLogic extends Application_Model_Image
{
    
    public function fetchOrdered($id)
    {
        return $this->fetchAll($this->select()->where('image_album = ?', $id)->where('image_status != ?', 'D')->order('image_title'));
    }
    
    public function fetchDataTableSelect($id) 
    {
        $columns = array('image_title', 'image_desc', 'image_status', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_ImageLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('image_album = ?', $id)->where('image_status != ?', 'D');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $enc = new Application_Model_Util_Encrypt();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Album:Image:Edit")) {
                $action = '<a href="'.$url->url(array("controller"=>"image", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Album:Image:Delete")) {
                $action .= '<a href="'.$url->url(array("controller"=>"image", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $status = Application_Model_Cache_Config::getConfig('STATUS_TYPE');
            $results[$i] = array($row->image_title, $row->image_desc, $status[$row->image_status], $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
}

