<?php

class Application_Model_Library extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_library';

    private $_id = null;

    private $_library_title = null;

    private $_library_desc = null;

    private $_library_file = null;

    private $_library_visibility = null;

    private $_library_category = null;

    private $_library_status = null;

    private $_library_updated_by = null;

    private $_library_updated_date = null;

    private $_library_created_by = null;

    private $_library_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get library_title method is stand for get the value of library_title.
     *
     * @var varchar library_title
     */
    public function get_library_title()
    {
        return $this->_library_title;
    }

    /**
     * set library_title method is stand for set the value of library_title.
     *
     * @var varchar library_title
     */
    public function set_library_title($value)
    {
        $this->_library_title = $value;
    }

    /**
     * get library_desc method is stand for get the value of library_desc.
     *
     * @var varchar library_desc
     */
    public function get_library_desc()
    {
        return $this->_library_desc;
    }

    /**
     * set library_desc method is stand for set the value of library_desc.
     *
     * @var varchar library_desc
     */
    public function set_library_desc($value)
    {
        $this->_library_desc = $value;
    }

    /**
     * get library_file method is stand for get the value of library_file.
     *
     * @var varchar library_file
     */
    public function get_library_file()
    {
        return $this->_library_file;
    }

    /**
     * set library_file method is stand for set the value of library_file.
     *
     * @var varchar library_file
     */
    public function set_library_file($value)
    {
        $this->_library_file = $value;
    }

    /**
     * get library_visibility method is stand for get the value of library_visibility.
     *
     * @var varchar library_visibility
     */
    public function get_library_visibility()
    {
        return $this->_library_visibility;
    }

    /**
     * set library_visibility method is stand for set the value of library_visibility.
     *
     * @var varchar library_visibility
     */
    public function set_library_visibility($value)
    {
        $this->_library_visibility = $value;
    }

    /**
     * get library_category method is stand for get the value of library_category.
     *
     * @var int library_category
     */
    public function get_library_category()
    {
        return (int) $this->_library_category;
    }

    /**
     * set library_category method is stand for set the value of library_category.
     *
     * @var int library_category
     */
    public function set_library_category($value)
    {
        $this->_library_category = (int) $value;
    }

    /**
     * get library_status method is stand for get the value of library_status.
     *
     * @var varchar library_status
     */
    public function get_library_status()
    {
        return $this->_library_status;
    }

    /**
     * set library_status method is stand for set the value of library_status.
     *
     * @var varchar library_status
     */
    public function set_library_status($value)
    {
        $this->_library_status = $value;
    }

    /**
     * get library_updated_by method is stand for get the value of library_updated_by.
     *
     * @var int library_updated_by
     */
    public function get_library_updated_by()
    {
        return (int) $this->_library_updated_by;
    }

    /**
     * set library_updated_by method is stand for set the value of library_updated_by.
     *
     * @var int library_updated_by
     */
    public function set_library_updated_by($value)
    {
        $this->_library_updated_by = (int) $value;
    }

    /**
     * get library_updated_date method is stand for get the value of
     * library_updated_date.
     *
     * @var timestamp library_updated_date
     */
    public function get_library_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_library_updated_date));
    }

    /**
     * set library_updated_date method is stand for set the value of
     * library_updated_date.
     *
     * @var timestamp library_updated_date
     */
    public function set_library_updated_date($value)
    {
        $this->_library_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get library_created_by method is stand for get the value of library_created_by.
     *
     * @var int library_created_by
     */
    public function get_library_created_by()
    {
        return (int) $this->_library_created_by;
    }

    /**
     * set library_created_by method is stand for set the value of library_created_by.
     *
     * @var int library_created_by
     */
    public function set_library_created_by($value)
    {
        $this->_library_created_by = (int) $value;
    }

    /**
     * get library_created_date method is stand for get the value of
     * library_created_date.
     *
     * @var timestamp library_created_date
     */
    public function get_library_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_library_created_date));
    }

    /**
     * set library_created_date method is stand for set the value of
     * library_created_date.
     *
     * @var timestamp library_created_date
     */
    public function set_library_created_date($value)
    {
        $this->_library_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_library by set id thru constructor.
     *
     * @var int id
     * @var varchar library_title
     * @var varchar library_desc
     * @var varchar library_file
     * @var varchar library_visibility
     * @var int library_category
     * @var varchar library_status
     * @var int library_updated_by
     * @var timestamp library_updated_date
     * @var int library_created_by
     * @var timestamp library_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_library_title($row->library_title);
          $this->set_library_desc($row->library_desc);
          $this->set_library_file($row->library_file);
          $this->set_library_visibility($row->library_visibility);
          $this->set_library_category($row->library_category);
          $this->set_library_status($row->library_status);
          $this->set_library_updated_by($row->library_updated_by);
          $this->set_library_updated_date($row->library_updated_date);
          $this->set_library_created_by($row->library_created_by);
          $this->set_library_created_date($row->library_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar library_title
     * @var varchar library_desc
     * @var varchar library_file
     * @var varchar library_visibility
     * @var int library_category
     * @var varchar library_status
     * @var int library_updated_by
     * @var int library_created_by
     */
    public function save()
    {
        $data = array(
          "library_title" => $this->get_library_title(),
          "library_desc" => $this->get_library_desc(),
          "library_file" => $this->get_library_file(),
          "library_visibility" => $this->get_library_visibility(),
          "library_category" => $this->get_library_category(),
          "library_status" => $this->get_library_status(),
          "library_updated_by" => $this->get_library_updated_by(),
          "library_created_by" => $this->get_library_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_library by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_library_title_by_id method is stand for get the value oflibrary_title By id.
     *
     * @var varchar library_title
     */
    public function get_library_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_library_title();
    }

    /**
     * get_library_desc_by_id method is stand for get the value oflibrary_desc By id.
     *
     * @var varchar library_desc
     */
    public function get_library_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_library_desc();
    }

    /**
     * get_library_file_by_id method is stand for get the value oflibrary_file By id.
     *
     * @var varchar library_file
     */
    public function get_library_file_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_library_file();
    }

    /**
     * get_library_visibility_by_id method is stand for get the value
     * oflibrary_visibility By id.
     *
     * @var varchar library_visibility
     */
    public function get_library_visibility_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_library_visibility();
    }

    /**
     * get_library_category_by_id method is stand for get the value oflibrary_category
     * By id.
     *
     * @var int library_category
     */
    public function get_library_category_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_library_category();
    }

    /**
     * get_library_status_by_id method is stand for get the value oflibrary_status By
     * id.
     *
     * @var varchar library_status
     */
    public function get_library_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_library_status();
    }

    /**
     * get_library_updated_by_by_id method is stand for get the value
     * oflibrary_updated_by By id.
     *
     * @var int library_updated_by
     */
    public function get_library_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_library_updated_by();
    }

    /**
     * get_library_updated_date_by_id method is stand for get the value
     * oflibrary_updated_date By id.
     *
     * @var timestamp library_updated_date
     */
    public function get_library_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_library_updated_date()));
    }

    /**
     * get_library_created_by_by_id method is stand for get the value
     * oflibrary_created_by By id.
     *
     * @var int library_created_by
     */
    public function get_library_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_library_created_by();
    }

    /**
     * get_library_created_date_by_id method is stand for get the value
     * oflibrary_created_date By id.
     *
     * @var timestamp library_created_date
     */
    public function get_library_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_library_created_date()));
    }


}
