<?php

class Application_Model_LibraryLogic extends Application_Model_Library
{
    
    public function fetchDataTableSelect() 
    {
        $user = new Application_Model_UserLogic(-1);
        $columns = array('library_title', 'library_desc', 'library_visibility', 'user_name', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_LibraryLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->from(array("l"=>$this->_name, "u"=>"asit_user"), 
                array("l.id", "l.library_title", "l.library_desc", "l.library_visibility", "l.library_file", 'u.user_name'));
        $where->join(array("u"=>"asit_user"),
                'l.library_created_by = u.id', array())
                ->setIntegrityCheck(false);
        $where->where('library_status = ?', 'A')->where("(library_visibility = 'Public' or library_created_by = ?)", $user->getLoggedInUserId());
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $baseUrl = new Zend_View_Helper_BaseUrl();
        foreach($rows as $row)
        {
            if(Application_Model_RolePermissionLogic::isPermitted("Library:Download")) {
                $action = '<a href="'.$baseUrl->baseUrl('dynasty/download/library/'.$row->library_file).'" target="_blank"><input type="button" value="Download" class="btn btn-primary" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Library:Edit")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"library", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Library:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"library", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->library_title, $row->library_desc, $row->library_visibility, $row->user_name, $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }

}

