<?php

class Application_Model_ListCategoryLogic extends Application_Model_ListCategory
{
    
    public function getActiveCategory($listId)
    {
        $where = $this->select()->where('list_id = ?', $listId)->where('list_category_status = ?', 'A');
        return $this->fetchAll($where);
    }
    
    public function insertCategory($listId, $categoryId)
    {
        $this->set_id(-1);
        $this->set_list_id($listId);
        $this->set_category_id($categoryId);
        $this->set_list_category_status('A');
        $user = new Application_Model_UserLogic(-1);
        $this->set_list_category_created_by($user->getLoggedInUserId());
        $this->set_list_category_updated_by($user->getLoggedInUserId());
        $this->save();
    }
    
    public function removeByListId($listId)
    {
        $data = array("list_category_status" => 'D');
        $where = $this->getAdapter()->quoteInto("list_id = ?", $listId);
        $this->delete($where);
    }
    
}

