<?php

class Application_Model_ListImage extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_list_image';

    private $_id = null;

    private $_list_id = null;

    private $_image_path = null;

    private $_list_image_status = null;

    private $_list_image_updated_by = null;

    private $_list_image_updated_date = null;

    private $_list_image_created_by = null;

    private $_list_image_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get list_id method is stand for get the value of list_id.
     *
     * @var int list_id
     */
    public function get_list_id()
    {
        return (int) $this->_list_id;
    }

    /**
     * set list_id method is stand for set the value of list_id.
     *
     * @var int list_id
     */
    public function set_list_id($value)
    {
        $this->_list_id = (int) $value;
    }

    /**
     * get image_path method is stand for get the value of image_path.
     *
     * @var varchar image_path
     */
    public function get_image_path()
    {
        return $this->_image_path;
    }

    /**
     * set image_path method is stand for set the value of image_path.
     *
     * @var varchar image_path
     */
    public function set_image_path($value)
    {
        $this->_image_path = $value;
    }

    /**
     * get list_image_status method is stand for get the value of list_image_status.
     *
     * @var varchar list_image_status
     */
    public function get_list_image_status()
    {
        return $this->_list_image_status;
    }

    /**
     * set list_image_status method is stand for set the value of list_image_status.
     *
     * @var varchar list_image_status
     */
    public function set_list_image_status($value)
    {
        $this->_list_image_status = $value;
    }

    /**
     * get list_image_updated_by method is stand for get the value of
     * list_image_updated_by.
     *
     * @var int list_image_updated_by
     */
    public function get_list_image_updated_by()
    {
        return (int) $this->_list_image_updated_by;
    }

    /**
     * set list_image_updated_by method is stand for set the value of
     * list_image_updated_by.
     *
     * @var int list_image_updated_by
     */
    public function set_list_image_updated_by($value)
    {
        $this->_list_image_updated_by = (int) $value;
    }

    /**
     * get list_image_updated_date method is stand for get the value of
     * list_image_updated_date.
     *
     * @var timestamp list_image_updated_date
     */
    public function get_list_image_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_list_image_updated_date));
    }

    /**
     * set list_image_updated_date method is stand for set the value of
     * list_image_updated_date.
     *
     * @var timestamp list_image_updated_date
     */
    public function set_list_image_updated_date($value)
    {
        $this->_list_image_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get list_image_created_by method is stand for get the value of
     * list_image_created_by.
     *
     * @var int list_image_created_by
     */
    public function get_list_image_created_by()
    {
        return (int) $this->_list_image_created_by;
    }

    /**
     * set list_image_created_by method is stand for set the value of
     * list_image_created_by.
     *
     * @var int list_image_created_by
     */
    public function set_list_image_created_by($value)
    {
        $this->_list_image_created_by = (int) $value;
    }

    /**
     * get list_image_created_date method is stand for get the value of
     * list_image_created_date.
     *
     * @var timestamp list_image_created_date
     */
    public function get_list_image_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_list_image_created_date));
    }

    /**
     * set list_image_created_date method is stand for set the value of
     * list_image_created_date.
     *
     * @var timestamp list_image_created_date
     */
    public function set_list_image_created_date($value)
    {
        $this->_list_image_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_list_image by set id thru constructor.
     *
     * @var int id
     * @var int list_id
     * @var varchar image_path
     * @var varchar list_image_status
     * @var int list_image_updated_by
     * @var timestamp list_image_updated_date
     * @var int list_image_created_by
     * @var timestamp list_image_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_list_id($row->list_id);
          $this->set_image_path($row->image_path);
          $this->set_list_image_status($row->list_image_status);
          $this->set_list_image_updated_by($row->list_image_updated_by);
          $this->set_list_image_updated_date($row->list_image_updated_date);
          $this->set_list_image_created_by($row->list_image_created_by);
          $this->set_list_image_created_date($row->list_image_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var int list_id
     * @var varchar image_path
     * @var varchar list_image_status
     * @var int list_image_updated_by
     * @var int list_image_created_by
     */
    public function save()
    {
        $data = array(
          "list_id" => $this->get_list_id(),
          "image_path" => $this->get_image_path(),
          "list_image_status" => $this->get_list_image_status(),
          "list_image_updated_by" => $this->get_list_image_updated_by(),
          "list_image_created_by" => $this->get_list_image_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_list_image by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_list_id_by_id method is stand for get the value oflist_id By id.
     *
     * @var int list_id
     */
    public function get_list_id_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_list_id();
    }

    /**
     * get_image_path_by_id method is stand for get the value ofimage_path By id.
     *
     * @var varchar image_path
     */
    public function get_image_path_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_image_path();
    }

    /**
     * get_list_image_status_by_id method is stand for get the value
     * oflist_image_status By id.
     *
     * @var varchar list_image_status
     */
    public function get_list_image_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_list_image_status();
    }

    /**
     * get_list_image_updated_by_by_id method is stand for get the value
     * oflist_image_updated_by By id.
     *
     * @var int list_image_updated_by
     */
    public function get_list_image_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_list_image_updated_by();
    }

    /**
     * get_list_image_updated_date_by_id method is stand for get the value
     * oflist_image_updated_date By id.
     *
     * @var timestamp list_image_updated_date
     */
    public function get_list_image_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_list_image_updated_date()));
    }

    /**
     * get_list_image_created_by_by_id method is stand for get the value
     * oflist_image_created_by By id.
     *
     * @var int list_image_created_by
     */
    public function get_list_image_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_list_image_created_by();
    }

    /**
     * get_list_image_created_date_by_id method is stand for get the value
     * oflist_image_created_date By id.
     *
     * @var timestamp list_image_created_date
     */
    public function get_list_image_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_list_image_created_date()));
    }


}
