<?php

class Application_Model_ListLogic extends Application_Model_List
{
    const LIST_TYPE_NORMAL_KEY = 'N';
    const LIST_TYPE_TRENDING_KEY = 'T';
    const LIST_TYPE_FEATURED_KEY = 'F';
    const LIST_TYPE_SPONSORED_KEY = 'S';
    
    public static $listType = array(self::LIST_TYPE_NORMAL_KEY =>'Normal', self::LIST_TYPE_FEATURED_KEY=>'Featured');
            //array(self::LIST_TYPE_NORMAL_KEY =>'Normal', self::LIST_TYPE_TRENDING_KEY=>'Trending',
        //self::LIST_TYPE_FEATURED_KEY=>'Featured', self::LIST_TYPE_SPONSORED_KEY=>'Sponsored');
    
    public function fetchDataTableSelect()
    {
        $columns = array('list_title', 'city_name', 'category_title', 'list_type', 'list_phone', 'list_email', 'list_visitors', 'list_abuse', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_ListLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->from(array("l"=>$this->_name, "c"=>'asit_city', 'cat'=>'asit_category'), 
                array("l.id", 'l.list_title', "c.city_name", 'cat.category_title', 'l.list_type', 'l.list_phone', 'l.list_email', 'l.list_visitors', 'l.list_abuse', 'l.list_website'));
        $where->joinLeft(array("c"=>"asit_city"),
                'l.list_city = c.id', array())
                ->setIntegrityCheck(false);
        $where->joinLeft(array("cat"=>"asit_category"),
                'l.list_category = cat.id', array())
                ->setIntegrityCheck(false);
        $where->where('l.list_status != ?', 'D');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("List:Edit")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"list", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("List:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"list", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("List:Edit")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"list", "action"=>"image", "id"=>$row->id)).'"><input type="button" value="Manage Image" class="btn btn-info" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Review:Master")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"review", "action"=>"index", "id"=>$row->id)).'"><input type="button" value="Manage Review" class="btn btn-info" /></a>';
            }
            $results[$i] = array($row->list_title, $row->city_name, $row->category_title, $row->list_type, $row->list_phone, $row->list_email, $row->list_visitors, $row->list_abuse, $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getActiveListings() {
        $where = $this->select()->where('list_status = ?', 'A')->order('list_title');
        return $this->fetchAll($where);
    }
    
    public function getRecentListings() {
        $where = $this->select()->where('list_status = ?', 'A')->order('id desc')->limit(3);
        return $this->fetchAll($where);
    }
    
    public function getFeaturedListings() {
        $where = $this->select()->where('list_status = ?', 'A')->where('list_type = ?', 'F')->order('rand()')->limit(3);
        return $this->fetchAll($where);
    }
    
    public function countListUrl($url) {
        $where = $this->select()->where('list_status = ?', 'A')->where('list_url = ?', $url);
        return count($this->fetchAll($where));
    }
    
    public function generateListUrl($url) {
        $url = strtolower(preg_replace('/[^a-zA-Z0-9]/', '-', $url));
        $existRecord = $this->countListUrl($url);
        if($existRecord > 0) {
            return $url.'-'.$existRecord;
        }else {
            return $url;
        }
    }
    
    public function getListByType($type) {
        $where = $this->select()->where('list_status = ?', 'A')->where('list_type = ?', $type);
        return $this->fetchAll($where);
    }
    
    public function getListingsByCity($city) {
        $where = $this->select()->where('list_status  = ?', 'A')->where('list_city  = ?', $city);
        return $where;
    }
    
    public function getListingsByCategory($catId, $loc = null) {
        $where = $this->select()->where('list_status  = ?', 'A');
        if(!empty($loc)) {
            $where->where('lower(replace(list_area, \' \', \'-\'))=?', $loc);
        }
        $select = $this->select()->orWhere('list_category = ?', $catId)->orWhere('id in (select list_id from asit_list_category where list_category_status = \'A\' and category_id = ?)', $catId);
        $where->where(implode(' ', $select->getPart(Zend_Db_Select::WHERE)))->order('id');
        return $where;
    }
    
    public function countListingsByCategory($catId) {
        $result = $this->getAdapter()->fetchRow("SELECT count(*) as total FROM `asit_list` where list_status = 'A' and (list_category = ? or id in (select list_id from asit_list_category where list_category_status = 'A' and category_id = ?))", array($catId, $catId));
        return $result['total'];
    }
    
    public function getListingLocationByCategory($catId) {
        $sql = "SELECT list_area as location, count(*) as total FROM `asit_list` where list_status = 'A' and (list_category = ? or id in (select list_id from asit_list_category where list_category_status = 'A' and category_id = ? )) group by list_area";
        return $this->getAdapter()->fetchAll($sql, array($catId, $catId));
    } 
    
    public function getListIdByUrl($url) {
        $where = $this->select()->where('list_url = ?', $url)->where('list_status = ?', 'A');
        $row = $this->fetchRow($where);
        return $row['id'];
    }
    
    public function getReviewScoreStar($count) {
        $star = '';
        if($count > 0) {
            $count = ($count < 1) ? 1 : $count;
            $count = ($count > 5) ? 5 : $count;
            $isFloat = (is_float($count)) ? true : false;
            $count = ($isFloat) ? floor($count) : $count;
            for($i=0; $i<$count; $i++) {
                $star .= '<i class="fa fa-star"></i>';
            }
            $star .= ($isFloat) ? '<i class="fa fa-star-half-o"></i>' : '';
            if($isFloat)
                $count += 1;
            for($i=0; $i<(5 - $count); $i++) {
                $star .= '<i class="fa fa-star-o"></i>';
            }
        }else {
            for($i=0; $i<(5); $i++) {
                $star .= '<i class="fa fa-star-o"></i>';
            }
        }
        return $star;
    }
    
    public function getReviewScoreTag($count) {
        $count = ($count > 5) ? 5 : $count;
        $tags = array('NOT AVAILABLE', 'BAD', 'NOT GOOD', 'REGULAR', 'GOOD', 'EXCELLENT');
        return $tags[ceil($count)];
    }
    
    public function getReviewScoreIcon($count) {
        $count = ($count > 5) ? 5 : $count;
        $icon = array('icon-happy', 'icon-mad', 'icon-wondering', 'icon-neutral', 'icon-smile', 'icon-happy');
        return $icon[ceil($count)];
    }
    
    public function getOrderedDistinctLocation() {
        return $this->getAdapter()->fetchAll("select distinct list_area from asit_list order by list_area");
    }
    
    public function getActiveListingsOfMonth($start, $end)
    {
        $where = $this->select()->where('list_status = ?', 'A')->where('list_created_date <= ?', $end)->where('list_created_date >= ?', $start);
        return $this->fetchAll($where);
    }
}

