<?php

class Application_Model_ListMeta  extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_list_meta';

    private $_id = null;

    private $_list_id = null;

    private $_list_fb = null;

    private $_list_tweet = null;

    private $_list_insta = null;

    private $_list_amenities = null;

    private $_list_target = null;

    private $_list_tags = null;

    private $_list_updated_by = null;

    private $_list_updated_date = null;

    private $_list_created_by = null;

    private $_list_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get list_id method is stand for get the value of list_id.
     *
     * @var int list_id
     */
    public function get_list_id()
    {
        return (int) $this->_list_id;
    }

    /**
     * set list_id method is stand for set the value of list_id.
     *
     * @var int list_id
     */
    public function set_list_id($value)
    {
        $this->_list_id = (int) $value;
    }

    /**
     * get list_fb method is stand for get the value of list_fb.
     *
     * @var varchar list_fb
     */
    public function get_list_fb()
    {
        return $this->_list_fb;
    }

    /**
     * set list_fb method is stand for set the value of list_fb.
     *
     * @var varchar list_fb
     */
    public function set_list_fb($value)
    {
        $this->_list_fb = $value;
    }

    /**
     * get list_tweet method is stand for get the value of list_tweet.
     *
     * @var varchar list_tweet
     */
    public function get_list_tweet()
    {
        return $this->_list_tweet;
    }

    /**
     * set list_tweet method is stand for set the value of list_tweet.
     *
     * @var varchar list_tweet
     */
    public function set_list_tweet($value)
    {
        $this->_list_tweet = $value;
    }

    /**
     * get list_insta method is stand for get the value of list_insta.
     *
     * @var varchar list_insta
     */
    public function get_list_insta()
    {
        return $this->_list_insta;
    }

    /**
     * set list_insta method is stand for set the value of list_insta.
     *
     * @var varchar list_insta
     */
    public function set_list_insta($value)
    {
        $this->_list_insta = $value;
    }

    /**
     * get list_amenities method is stand for get the value of list_amenities.
     *
     * @var varchar list_amenities
     */
    public function get_list_amenities()
    {
        return $this->_list_amenities;
    }

    /**
     * set list_amenities method is stand for set the value of list_amenities.
     *
     * @var varchar list_amenities
     */
    public function set_list_amenities($value)
    {
        $this->_list_amenities = $value;
    }

    /**
     * get list_target method is stand for get the value of list_target.
     *
     * @var varchar list_target
     */
    public function get_list_target()
    {
        return $this->_list_target;
    }

    /**
     * set list_target method is stand for set the value of list_target.
     *
     * @var varchar list_target
     */
    public function set_list_target($value)
    {
        $this->_list_target = $value;
    }

    /**
     * get list_tags method is stand for get the value of list_tags.
     *
     * @var varchar list_tags
     */
    public function get_list_tags()
    {
        return $this->_list_tags;
    }

    /**
     * set list_tags method is stand for set the value of list_tags.
     *
     * @var varchar list_tags
     */
    public function set_list_tags($value)
    {
        $this->_list_tags = $value;
    }

    /**
     * get list_updated_by method is stand for get the value of list_updated_by.
     *
     * @var int list_updated_by
     */
    public function get_list_updated_by()
    {
        return (int) $this->_list_updated_by;
    }

    /**
     * set list_updated_by method is stand for set the value of list_updated_by.
     *
     * @var int list_updated_by
     */
    public function set_list_updated_by($value)
    {
        $this->_list_updated_by = (int) $value;
    }

    /**
     * get list_updated_date method is stand for get the value of list_updated_date.
     *
     * @var timestamp list_updated_date
     */
    public function get_list_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_list_updated_date));
    }

    /**
     * set list_updated_date method is stand for set the value of list_updated_date.
     *
     * @var timestamp list_updated_date
     */
    public function set_list_updated_date($value)
    {
        $this->_list_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get list_created_by method is stand for get the value of list_created_by.
     *
     * @var int list_created_by
     */
    public function get_list_created_by()
    {
        return (int) $this->_list_created_by;
    }

    /**
     * set list_created_by method is stand for set the value of list_created_by.
     *
     * @var int list_created_by
     */
    public function set_list_created_by($value)
    {
        $this->_list_created_by = (int) $value;
    }

    /**
     * get list_created_date method is stand for get the value of list_created_date.
     *
     * @var timestamp list_created_date
     */
    public function get_list_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_list_created_date));
    }

    /**
     * set list_created_date method is stand for set the value of list_created_date.
     *
     * @var timestamp list_created_date
     */
    public function set_list_created_date($value)
    {
        $this->_list_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_list_meta by set id thru constructor.
     *
     * @var int id
     * @var int list_id
     * @var varchar list_fb
     * @var varchar list_tweet
     * @var varchar list_insta
     * @var varchar list_amenities
     * @var varchar list_target
     * @var varchar list_tags
     * @var int list_updated_by
     * @var timestamp list_updated_date
     * @var int list_created_by
     * @var timestamp list_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_list_id($row->list_id);
          $this->set_list_fb($row->list_fb);
          $this->set_list_tweet($row->list_tweet);
          $this->set_list_insta($row->list_insta);
          $this->set_list_amenities($row->list_amenities);
          $this->set_list_target($row->list_target);
          $this->set_list_tags($row->list_tags);
          $this->set_list_updated_by($row->list_updated_by);
          $this->set_list_updated_date($row->list_updated_date);
          $this->set_list_created_by($row->list_created_by);
          $this->set_list_created_date($row->list_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var int list_id
     * @var varchar list_fb
     * @var varchar list_tweet
     * @var varchar list_insta
     * @var varchar list_amenities
     * @var varchar list_target
     * @var varchar list_tags
     * @var int list_updated_by
     * @var int list_created_by
     */
    public function save()
    {
        $data = array(
          "list_id" => $this->get_list_id(),
          "list_fb" => $this->get_list_fb(),
          "list_tweet" => $this->get_list_tweet(),
          "list_insta" => $this->get_list_insta(),
          "list_amenities" => $this->get_list_amenities(),
          "list_target" => $this->get_list_target(),
          "list_tags" => $this->get_list_tags(),
          "list_updated_by" => $this->get_list_updated_by(),
          "list_created_by" => $this->get_list_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_list_meta by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_list_id_by_id method is stand for get the value oflist_id By id.
     *
     * @var int list_id
     */
    public function get_list_id_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_list_id();
    }

    /**
     * get_list_fb_by_id method is stand for get the value oflist_fb By id.
     *
     * @var varchar list_fb
     */
    public function get_list_fb_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_list_fb();
    }

    /**
     * get_list_tweet_by_id method is stand for get the value oflist_tweet By id.
     *
     * @var varchar list_tweet
     */
    public function get_list_tweet_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_list_tweet();
    }

    /**
     * get_list_insta_by_id method is stand for get the value oflist_insta By id.
     *
     * @var varchar list_insta
     */
    public function get_list_insta_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_list_insta();
    }

    /**
     * get_list_amenities_by_id method is stand for get the value oflist_amenities By
     * id.
     *
     * @var varchar list_amenities
     */
    public function get_list_amenities_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_list_amenities();
    }

    /**
     * get_list_target_by_id method is stand for get the value oflist_target By id.
     *
     * @var varchar list_target
     */
    public function get_list_target_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_list_target();
    }

    /**
     * get_list_tags_by_id method is stand for get the value oflist_tags By id.
     *
     * @var varchar list_tags
     */
    public function get_list_tags_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_list_tags();
    }

    /**
     * get_list_updated_by_by_id method is stand for get the value oflist_updated_by By
     * id.
     *
     * @var int list_updated_by
     */
    public function get_list_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_list_updated_by();
    }

    /**
     * get_list_updated_date_by_id method is stand for get the value
     * oflist_updated_date By id.
     *
     * @var timestamp list_updated_date
     */
    public function get_list_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_list_updated_date()));
    }

    /**
     * get_list_created_by_by_id method is stand for get the value oflist_created_by By
     * id.
     *
     * @var int list_created_by
     */
    public function get_list_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_list_created_by();
    }

    /**
     * get_list_created_date_by_id method is stand for get the value
     * oflist_created_date By id.
     *
     * @var timestamp list_created_date
     */
    public function get_list_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_list_created_date()));
    }
    
    public function getMetaByListId($listId)
    {
        $where = $this->select()->where('list_id = ?', $listId);
        $result = $this->fetchRow($where);
        if($result['id'] > 0) {
            $this->set_id($result['id']);
            $this->set_list_id($result['list_id']);
            $this->set_list_fb($result['list_fb']);
            $this->set_list_tweet($result['list_tweet']);
            $this->set_list_insta($result['list_insta']);
            $this->set_list_amenities($result['list_amenities']);
            $this->set_list_target($result['list_target']);
            $this->set_list_tags($result['list_tags']);
            $this->set_list_updated_by($result['list_updated_by']);
            $this->set_list_updated_date($result['list_updated_date']);
            $this->set_list_created_by($result['list_created_by']);
            $this->set_list_created_date($result['list_created_date']);
        }
        return $this;
    }


}
