<?php

class Application_Model_Log extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_log';

    private $_id = null;

    private $_log_user_id = null;

    private $_log_ip = null;

    private $_log_url = null;

    private $_log_updated_by = null;

    private $_log_updated_date = null;

    private $_log_created_by = null;

    private $_log_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get log_user_id method is stand for get the value of log_user_id.
     *
     * @var int log_user_id
     */
    public function get_log_user_id()
    {
        return (int) $this->_log_user_id;
    }

    /**
     * set log_user_id method is stand for set the value of log_user_id.
     *
     * @var int log_user_id
     */
    public function set_log_user_id($value)
    {
        $this->_log_user_id = (int) $value;
    }

    /**
     * get log_ip method is stand for get the value of log_ip.
     *
     * @var varchar log_ip
     */
    public function get_log_ip()
    {
        return $this->_log_ip;
    }

    /**
     * set log_ip method is stand for set the value of log_ip.
     *
     * @var varchar log_ip
     */
    public function set_log_ip($value)
    {
        $this->_log_ip = $value;
    }

    /**
     * get log_url method is stand for get the value of log_url.
     *
     * @var varchar log_url
     */
    public function get_log_url()
    {
        return $this->_log_url;
    }

    /**
     * set log_url method is stand for set the value of log_url.
     *
     * @var varchar log_url
     */
    public function set_log_url($value)
    {
        $this->_log_url = $value;
    }

    /**
     * get log_updated_by method is stand for get the value of log_updated_by.
     *
     * @var int log_updated_by
     */
    public function get_log_updated_by()
    {
        return (int) $this->_log_updated_by;
    }

    /**
     * set log_updated_by method is stand for set the value of log_updated_by.
     *
     * @var int log_updated_by
     */
    public function set_log_updated_by($value)
    {
        $this->_log_updated_by = (int) $value;
    }

    /**
     * get log_updated_date method is stand for get the value of log_updated_date.
     *
     * @var timestamp log_updated_date
     */
    public function get_log_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_log_updated_date));
    }

    /**
     * set log_updated_date method is stand for set the value of log_updated_date.
     *
     * @var timestamp log_updated_date
     */
    public function set_log_updated_date($value)
    {
        $this->_log_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get log_created_by method is stand for get the value of log_created_by.
     *
     * @var int log_created_by
     */
    public function get_log_created_by()
    {
        return (int) $this->_log_created_by;
    }

    /**
     * set log_created_by method is stand for set the value of log_created_by.
     *
     * @var int log_created_by
     */
    public function set_log_created_by($value)
    {
        $this->_log_created_by = (int) $value;
    }

    /**
     * get log_created_date method is stand for get the value of log_created_date.
     *
     * @var timestamp log_created_date
     */
    public function get_log_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_log_created_date));
    }

    /**
     * set log_created_date method is stand for set the value of log_created_date.
     *
     * @var timestamp log_created_date
     */
    public function set_log_created_date($value)
    {
        $this->_log_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_log by set id thru constructor.
     *
     * @var int id
     * @var int log_user_id
     * @var varchar log_ip
     * @var varchar log_url
     * @var int log_updated_by
     * @var timestamp log_updated_date
     * @var int log_created_by
     * @var timestamp log_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_log_user_id($row->log_user_id);
          $this->set_log_ip($row->log_ip);
          $this->set_log_url($row->log_url);
          $this->set_log_updated_by($row->log_updated_by);
          $this->set_log_updated_date($row->log_updated_date);
          $this->set_log_created_by($row->log_created_by);
          $this->set_log_created_date($row->log_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var int log_user_id
     * @var varchar log_ip
     * @var varchar log_url
     * @var int log_updated_by
     * @var int log_created_by
     */
    public function save()
    {
        $data = array(
          "log_user_id" => $this->get_log_user_id(),
          "log_ip" => $this->get_log_ip(),
          "log_url" => $this->get_log_url(),
          "log_updated_by" => $this->get_log_updated_by(),
          "log_created_by" => $this->get_log_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_log by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_log_user_id_by_id method is stand for get the value oflog_user_id By id.
     *
     * @var int log_user_id
     */
    public function get_log_user_id_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_log_user_id();
    }

    /**
     * get_log_ip_by_id method is stand for get the value oflog_ip By id.
     *
     * @var varchar log_ip
     */
    public function get_log_ip_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_log_ip();
    }

    /**
     * get_log_url_by_id method is stand for get the value oflog_url By id.
     *
     * @var varchar log_url
     */
    public function get_log_url_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_log_url();
    }

    /**
     * get_log_updated_by_by_id method is stand for get the value oflog_updated_by By
     * id.
     *
     * @var int log_updated_by
     */
    public function get_log_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_log_updated_by();
    }

    /**
     * get_log_updated_date_by_id method is stand for get the value oflog_updated_date
     * By id.
     *
     * @var timestamp log_updated_date
     */
    public function get_log_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_log_updated_date()));
    }

    /**
     * get_log_created_by_by_id method is stand for get the value oflog_created_by By
     * id.
     *
     * @var int log_created_by
     */
    public function get_log_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_log_created_by();
    }

    /**
     * get_log_created_date_by_id method is stand for get the value oflog_created_date
     * By id.
     *
     * @var timestamp log_created_date
     */
    public function get_log_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_log_created_date()));
    }


}
