<?php

class Application_Model_LogLogic extends Application_Model_Log
{
    
    public function insertLog()
    {
        $request = Application_Model_Util_Util::getRequest();
        $obj_user = new Application_Model_UserLogic(-1);
        $this->set_id(-1);
        $this->set_log_ip($request->getClientIp());
        $this->set_log_url($request->getRequestUri());
        $this->set_log_user_id($obj_user->getLoggedInUserId());
        $this->set_log_updated_by(0);
        $this->set_log_created_by(0);
        $this->save();
    }
    
    public function fetchDataTableSelect() 
    {
        $columns = array('log_created_date', 'user_name', 'log_ip', 'log_url');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_LogLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->from(array("l"=>$this->_name, "u"=>"asit_user"), 
                array("l.log_created_date", "u.user_name", 'l.log_ip', 'l.log_url'));
        $where->join(array("u"=>"asit_user"),
                'l.log_user_id = u.id', array())
                ->setIntegrityCheck(false);
        $where->order('l.id desc');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        foreach($rows as $row)
        {
            $results[$i] = array(Application_Model_Util_Date::convertToDisplay($row->log_created_date), $row->user_name, $row->log_ip, $row->log_url);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }


}

