<?php

class Application_Model_Menu extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_menu';

    private $_id = null;

    private $_menu_title = null;

    private $_menu_desc = null;

    private $_menu_content = null;

    private $_menu_url = null;

    private $_menu_type = null;

    private $_menu_parent = null;

    private $_menu_status = null;

    private $_menu_order = null;

    private $_menu_updated_by = null;

    private $_menu_updated_date = null;

    private $_menu_created_by = null;

    private $_menu_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get menu_title method is stand for get the value of menu_title.
     *
     * @var varchar menu_title
     */
    public function get_menu_title()
    {
        return $this->_menu_title;
    }

    /**
     * set menu_title method is stand for set the value of menu_title.
     *
     * @var varchar menu_title
     */
    public function set_menu_title($value)
    {
        $this->_menu_title = $value;
    }

    /**
     * get menu_desc method is stand for get the value of menu_desc.
     *
     * @var varchar menu_desc
     */
    public function get_menu_desc()
    {
        return $this->_menu_desc;
    }

    /**
     * set menu_desc method is stand for set the value of menu_desc.
     *
     * @var varchar menu_desc
     */
    public function set_menu_desc($value)
    {
        $this->_menu_desc = $value;
    }

    /**
     * get menu_content method is stand for get the value of menu_content.
     *
     * @var int menu_content
     */
    public function get_menu_content()
    {
        return (int) $this->_menu_content;
    }

    /**
     * set menu_content method is stand for set the value of menu_content.
     *
     * @var int menu_content
     */
    public function set_menu_content($value)
    {
        $this->_menu_content = (int) $value;
    }

    /**
     * get menu_url method is stand for get the value of menu_url.
     *
     * @var varchar menu_url
     */
    public function get_menu_url()
    {
        return $this->_menu_url;
    }

    /**
     * set menu_url method is stand for set the value of menu_url.
     *
     * @var varchar menu_url
     */
    public function set_menu_url($value)
    {
        $this->_menu_url = $value;
    }

    /**
     * get menu_type method is stand for get the value of menu_type.
     *
     * @var varchar menu_type
     */
    public function get_menu_type()
    {
        return $this->_menu_type;
    }

    /**
     * set menu_type method is stand for set the value of menu_type.
     *
     * @var varchar menu_type
     */
    public function set_menu_type($value)
    {
        $this->_menu_type = $value;
    }

    /**
     * get menu_parent method is stand for get the value of menu_parent.
     *
     * @var int menu_parent
     */
    public function get_menu_parent()
    {
        return (int) $this->_menu_parent;
    }

    /**
     * set menu_parent method is stand for set the value of menu_parent.
     *
     * @var int menu_parent
     */
    public function set_menu_parent($value)
    {
        $this->_menu_parent = (int) $value;
    }

    /**
     * get menu_status method is stand for get the value of menu_status.
     *
     * @var varchar menu_status
     */
    public function get_menu_status()
    {
        return $this->_menu_status;
    }

    /**
     * set menu_status method is stand for set the value of menu_status.
     *
     * @var varchar menu_status
     */
    public function set_menu_status($value)
    {
        $this->_menu_status = $value;
    }

    /**
     * get menu_order method is stand for get the value of menu_order.
     *
     * @var int menu_order
     */
    public function get_menu_order()
    {
        return (int) $this->_menu_order;
    }

    /**
     * set menu_order method is stand for set the value of menu_order.
     *
     * @var int menu_order
     */
    public function set_menu_order($value)
    {
        $this->_menu_order = (int) $value;
    }

    /**
     * get menu_updated_by method is stand for get the value of menu_updated_by.
     *
     * @var int menu_updated_by
     */
    public function get_menu_updated_by()
    {
        return (int) $this->_menu_updated_by;
    }

    /**
     * set menu_updated_by method is stand for set the value of menu_updated_by.
     *
     * @var int menu_updated_by
     */
    public function set_menu_updated_by($value)
    {
        $this->_menu_updated_by = (int) $value;
    }

    /**
     * get menu_updated_date method is stand for get the value of menu_updated_date.
     *
     * @var timestamp menu_updated_date
     */
    public function get_menu_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_menu_updated_date));
    }

    /**
     * set menu_updated_date method is stand for set the value of menu_updated_date.
     *
     * @var timestamp menu_updated_date
     */
    public function set_menu_updated_date($value)
    {
        $this->_menu_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get menu_created_by method is stand for get the value of menu_created_by.
     *
     * @var int menu_created_by
     */
    public function get_menu_created_by()
    {
        return (int) $this->_menu_created_by;
    }

    /**
     * set menu_created_by method is stand for set the value of menu_created_by.
     *
     * @var int menu_created_by
     */
    public function set_menu_created_by($value)
    {
        $this->_menu_created_by = (int) $value;
    }

    /**
     * get menu_created_date method is stand for get the value of menu_created_date.
     *
     * @var timestamp menu_created_date
     */
    public function get_menu_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_menu_created_date));
    }

    /**
     * set menu_created_date method is stand for set the value of menu_created_date.
     *
     * @var timestamp menu_created_date
     */
    public function set_menu_created_date($value)
    {
        $this->_menu_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_menu by set id thru constructor.
     *
     * @var int id
     * @var varchar menu_title
     * @var varchar menu_desc
     * @var int menu_content
     * @var varchar menu_url
     * @var varchar menu_type
     * @var int menu_parent
     * @var varchar menu_status
     * @var int menu_order
     * @var int menu_updated_by
     * @var timestamp menu_updated_date
     * @var int menu_created_by
     * @var timestamp menu_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_menu_title($row->menu_title);
          $this->set_menu_desc($row->menu_desc);
          $this->set_menu_content($row->menu_content);
          $this->set_menu_url($row->menu_url);
          $this->set_menu_type($row->menu_type);
          $this->set_menu_parent($row->menu_parent);
          $this->set_menu_status($row->menu_status);
          $this->set_menu_order($row->menu_order);
          $this->set_menu_updated_by($row->menu_updated_by);
          $this->set_menu_updated_date($row->menu_updated_date);
          $this->set_menu_created_by($row->menu_created_by);
          $this->set_menu_created_date($row->menu_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar menu_title
     * @var varchar menu_desc
     * @var int menu_content
     * @var varchar menu_url
     * @var varchar menu_type
     * @var int menu_parent
     * @var varchar menu_status
     * @var int menu_order
     * @var int menu_updated_by
     * @var int menu_created_by
     */
    public function save()
    {
        $data = array(
          "menu_title" => $this->get_menu_title(),
          "menu_desc" => $this->get_menu_desc(),
          "menu_content" => $this->get_menu_content(),
          "menu_url" => $this->get_menu_url(),
          "menu_type" => $this->get_menu_type(),
          "menu_parent" => $this->get_menu_parent(),
          "menu_status" => $this->get_menu_status(),
          "menu_order" => $this->get_menu_order(),
          "menu_updated_by" => $this->get_menu_updated_by(),
          "menu_created_by" => $this->get_menu_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_menu by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_menu_title_by_id method is stand for get the value ofmenu_title By id.
     *
     * @var varchar menu_title
     */
    public function get_menu_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_menu_title();
    }

    /**
     * get_menu_desc_by_id method is stand for get the value ofmenu_desc By id.
     *
     * @var varchar menu_desc
     */
    public function get_menu_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_menu_desc();
    }

    /**
     * get_menu_content_by_id method is stand for get the value ofmenu_content By id.
     *
     * @var int menu_content
     */
    public function get_menu_content_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_menu_content();
    }

    /**
     * get_menu_url_by_id method is stand for get the value ofmenu_url By id.
     *
     * @var varchar menu_url
     */
    public function get_menu_url_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_menu_url();
    }

    /**
     * get_menu_type_by_id method is stand for get the value ofmenu_type By id.
     *
     * @var varchar menu_type
     */
    public function get_menu_type_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_menu_type();
    }

    /**
     * get_menu_parent_by_id method is stand for get the value ofmenu_parent By id.
     *
     * @var int menu_parent
     */
    public function get_menu_parent_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_menu_parent();
    }

    /**
     * get_menu_status_by_id method is stand for get the value ofmenu_status By id.
     *
     * @var varchar menu_status
     */
    public function get_menu_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_menu_status();
    }

    /**
     * get_menu_order_by_id method is stand for get the value ofmenu_order By id.
     *
     * @var int menu_order
     */
    public function get_menu_order_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_menu_order();
    }

    /**
     * get_menu_updated_by_by_id method is stand for get the value ofmenu_updated_by By
     * id.
     *
     * @var int menu_updated_by
     */
    public function get_menu_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_menu_updated_by();
    }

    /**
     * get_menu_updated_date_by_id method is stand for get the value
     * ofmenu_updated_date By id.
     *
     * @var timestamp menu_updated_date
     */
    public function get_menu_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_menu_updated_date()));
    }

    /**
     * get_menu_created_by_by_id method is stand for get the value ofmenu_created_by By
     * id.
     *
     * @var int menu_created_by
     */
    public function get_menu_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_menu_created_by();
    }

    /**
     * get_menu_created_date_by_id method is stand for get the value
     * ofmenu_created_date By id.
     *
     * @var timestamp menu_created_date
     */
    public function get_menu_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_menu_created_date()));
    }


}
