<?php

class Application_Model_MenuLogic extends Application_Model_Menu
{
    public function getAllParentMenu()
    {
        $where = $this->select()->where('menu_status = ?', 'A')->where('menu_parent = ?', 0)->order('menu_order');
        return $this->fetchAll($where);
    }
    
    public function isSubMenu($id)
    {
        $where = $this->select()->where('menu_status = ?', 'A')->where('menu_parent = ?', $id)->order('menu_order');
        return (count($this->fetchAll($where)) > 0) ? true : false;
    }
    
    public function getSubMenu($id)
    {
        $where = $this->select()->where('menu_status = ?', 'A')->where('menu_parent = ?', $id)->order('menu_order');
        return $this->fetchAll($where);
    }
    
    public function fetchDataTableSelect() 
    {
        $columns = array('m.menu_title', 'm.menu_desc', 'p.menu_title', 'm.menu_status', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_MenuLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->from(array("m"=>$this->_name, "p"=>$this->_name), 
                array("m.id", "m.menu_title", "m.menu_desc", 'p.menu_title as parent_menu', 'm.menu_status'));
        $where->joinLeft(array("p"=>  $this->_name),
                'm.menu_parent = p.id', array())
                ->setIntegrityCheck(false);
        $where->where('m.menu_status != ?', 'D');
        $where->order('m.id desc');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $enc = new Application_Model_Util_Encrypt();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Menu:Edit")) {
                $action = '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"menu", "action"=>"edit", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Edit" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Menu:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"menu", "action"=>"delete", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->menu_title, $row->menu_desc, (empty($row->parent_menu)) ? '<b>Parent Menu</b>' : $row->parent_menu, ($row->menu_status == 'A') ? 'Active' : 'Block', $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }

    public function getMenuContent($type)
    {
        $results = array();
        if ($type == 'L') {
            $obj_list = new Application_Model_ListLogic(-1);
            foreach ($obj_list->getActiveListings() as $list) {
                $results[$list->id] = $list->list_title;
            }
        } else if ($type == 'P') {
            $obj_page = new Application_Model_PageLogic(-1);
            foreach ($obj_page->getActivePages() as $page) {
                $results[$page->id] = $page->page_title;
            }
        } else if ($type == 'B') {
            $obj_blog = new Application_Model_BlogLogic(-1);
            foreach ($obj_blog->getActiveBlogs() as $blog) {
                $results[$blog->id] = $blog->blog_title;
            }
        } else if ($type == 'H') {
            $results["H"] = "Home";
        } else if ($type == 'EU') {
            $results["EU"] = "Upcming Events";
        } else if ($type == 'D') {
            $results["D"] = "Downloads";
        } else if ($type == 'U') {
            $results["U"] = "URL";
        }  else if ($type == 'G') {
            $results["G"] = "Gallery";
        }  else if ($type == 'N') {
            $results[0] = 'All';
            $obj_news = new Application_Model_NewsLogic(-1);
            foreach ($obj_news->getActiveNews() as $news) {
                $results[$news->id] = $news->news_title;
            }
        } else if ($type == 'C') {
            $results["C"] = "Circulars";
            /*$results[0] = 'All';
            $obj_cat = new Application_Model_CategoryLogic(-1);
            foreach ($obj_cat->getParentCategory() as $cat) {
                $results[$cat->id] = $cat->category_title;
            }*/
        } else if ($type == 'TC') {
            $results['TC'] = 'Transfer Certificates';
        } else if ($type == 'E') {
            $results['TC'] = 'Yearly Calendar';
        } else if ($type == 'A') {
            $results[0] = 'All';
            $obj_act = new Application_Model_ActivityLogic(-1);
            foreach ($obj_act->getActiveActivities() as $act) {
                $results[$act->id] = $act->activity_title;
            }
        } else if ($type == 'CU') {
            $results["CU"] = "Contact Us";
        }
        return $results;
    }
    
    public function getMenuUrl($type, $id)
    {
        $url = null;
        if ($type == 'L') {
            $obj_list = new Application_Model_ListLogic($id);
            $url = Application_Model_Util_Util::convertToUrl($obj_list->get_list_url());
        } else if ($type == 'P') {
            $obj_page = new Application_Model_PageLogic($id);
            $url = Application_Model_Util_Util::convertToUrl($obj_page->get_page_url());
        } else if ($type == 'B') {
            $obj_blog = new Application_Model_BlogLogic($id);
            $url = 'blog/'.Application_Model_Util_Util::convertToUrl($obj_blog->get_blog_url());
        } else if ($type == 'U') {
            $url = "url";
        } else if ($type == 'G') {
            $url = "gallery";
        } else if ($type == 'H') {
            $url = "index";
        } else if ($type == 'E') {
            $url = "events";
        } else if ($type == 'A') {
            if($id == 0) {
                $url = "activities";
            }else {
                $obj_act = new Application_Model_ActivityLogic(-1);
                $url = 'activity/'.Application_Model_Util_Util::convertToUrl($obj_act->get_activity_url());
            }
        } else if ($type == 'C') {
            $url = "page/circular";
            /*if($id == 0) {
                $url = "#";
            }else {
                $obj_cat = new Application_Model_CategoryLogic($id);
                $url = 'category/'.Application_Model_Util_Util::convertToUrl($obj_cat->get_category_title());
            }*/
        }  else if ($type == 'D') {
            $url = "page/download";
        } else if ($type == 'N') {
            if($id == 0) {
                $url = "news";
            }else {
                $obj_news = new Application_Model_NewsLogic($id);
                $url = 'news/'.Application_Model_Util_Util::convertToUrl($obj_news->get_news_url());
            }
        } else if ($type == 'TC') {
            $url = "tc";
        } else if ($type == 'CU') {
            $url = "contact-us";
        } else if ($type == 'EU') {
            $url = "event/upcoming";
        }
        return $url;
    }
    
    public static function convertTitleToUrl($title)
    {
        return strtolower(str_replace(' ', '-', $title));
    }
}

