<?php

class Application_Model_Message extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_messages';

    private $_id = null;

    private $_message_from_id = null;

    private $_message_to_id = null;

    private $_message_subject = null;

    private $_message_content = null;

    private $_message_is_view = null;

    private $_message_status = null;

    private $_message_updated_by = null;

    private $_message_updated_date = null;

    private $_message_created_by = null;

    private $_message_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get message_from_id method is stand for get the value of message_from_id.
     *
     * @var int message_from_id
     */
    public function get_message_from_id()
    {
        return (int) $this->_message_from_id;
    }

    /**
     * set message_from_id method is stand for set the value of message_from_id.
     *
     * @var int message_from_id
     */
    public function set_message_from_id($value)
    {
        $this->_message_from_id = (int) $value;
    }

    /**
     * get message_to_id method is stand for get the value of message_to_id.
     *
     * @var int message_to_id
     */
    public function get_message_to_id()
    {
        return (int) $this->_message_to_id;
    }

    /**
     * set message_to_id method is stand for set the value of message_to_id.
     *
     * @var int message_to_id
     */
    public function set_message_to_id($value)
    {
        $this->_message_to_id = (int) $value;
    }

    /**
     * get message_subject method is stand for get the value of message_subject.
     *
     * @var varchar message_subject
     */
    public function get_message_subject()
    {
        return $this->_message_subject;
    }

    /**
     * set message_subject method is stand for set the value of message_subject.
     *
     * @var varchar message_subject
     */
    public function set_message_subject($value)
    {
        $this->_message_subject = $value;
    }

    /**
     * get message_content method is stand for get the value of message_content.
     *
     * @var text message_content
     */
    public function get_message_content()
    {
        return $this->_message_content;
    }

    /**
     * set message_content method is stand for set the value of message_content.
     *
     * @var text message_content
     */
    public function set_message_content($value)
    {
        $this->_message_content = $value;
    }

    /**
     * get message_is_view method is stand for get the value of message_is_view.
     *
     * @var tinyint message_is_view
     */
    public function get_message_is_view()
    {
        return $this->_message_is_view;
    }

    /**
     * set message_is_view method is stand for set the value of message_is_view.
     *
     * @var tinyint message_is_view
     */
    public function set_message_is_view($value)
    {
        $this->_message_is_view = $value;
    }

    /**
     * get message_status method is stand for get the value of message_status.
     *
     * @var varchar message_status
     */
    public function get_message_status()
    {
        return $this->_message_status;
    }

    /**
     * set message_status method is stand for set the value of message_status.
     *
     * @var varchar message_status
     */
    public function set_message_status($value)
    {
        $this->_message_status = $value;
    }

    /**
     * get message_updated_by method is stand for get the value of message_updated_by.
     *
     * @var int message_updated_by
     */
    public function get_message_updated_by()
    {
        return (int) $this->_message_updated_by;
    }

    /**
     * set message_updated_by method is stand for set the value of message_updated_by.
     *
     * @var int message_updated_by
     */
    public function set_message_updated_by($value)
    {
        $this->_message_updated_by = (int) $value;
    }

    /**
     * get message_updated_date method is stand for get the value of
     * message_updated_date.
     *
     * @var timestamp message_updated_date
     */
    public function get_message_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_message_updated_date));
    }

    /**
     * set message_updated_date method is stand for set the value of
     * message_updated_date.
     *
     * @var timestamp message_updated_date
     */
    public function set_message_updated_date($value)
    {
        $this->_message_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get message_created_by method is stand for get the value of message_created_by.
     *
     * @var int message_created_by
     */
    public function get_message_created_by()
    {
        return (int) $this->_message_created_by;
    }

    /**
     * set message_created_by method is stand for set the value of message_created_by.
     *
     * @var int message_created_by
     */
    public function set_message_created_by($value)
    {
        $this->_message_created_by = (int) $value;
    }

    /**
     * get message_created_date method is stand for get the value of
     * message_created_date.
     *
     * @var timestamp message_created_date
     */
    public function get_message_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_message_created_date));
    }

    /**
     * set message_created_date method is stand for set the value of
     * message_created_date.
     *
     * @var timestamp message_created_date
     */
    public function set_message_created_date($value)
    {
        $this->_message_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_messages by set id thru constructor.
     *
     * @var int id
     * @var int message_from_id
     * @var int message_to_id
     * @var varchar message_subject
     * @var text message_content
     * @var tinyint message_is_view
     * @var varchar message_status
     * @var int message_updated_by
     * @var timestamp message_updated_date
     * @var int message_created_by
     * @var timestamp message_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_message_from_id($row->message_from_id);
          $this->set_message_to_id($row->message_to_id);
          $this->set_message_subject($row->message_subject);
          $this->set_message_content($row->message_content);
          $this->set_message_is_view($row->message_is_view);
          $this->set_message_status($row->message_status);
          $this->set_message_updated_by($row->message_updated_by);
          $this->set_message_updated_date($row->message_updated_date);
          $this->set_message_created_by($row->message_created_by);
          $this->set_message_created_date($row->message_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var int message_from_id
     * @var int message_to_id
     * @var varchar message_subject
     * @var text message_content
     * @var tinyint message_is_view
     * @var varchar message_status
     * @var int message_updated_by
     * @var int message_created_by
     */
    public function save()
    {
        $data = array(
          "message_from_id" => $this->get_message_from_id(),
          "message_to_id" => $this->get_message_to_id(),
          "message_subject" => $this->get_message_subject(),
          "message_content" => $this->get_message_content(),
          "message_is_view" => $this->get_message_is_view(),
          "message_status" => $this->get_message_status(),
          "message_updated_by" => $this->get_message_updated_by(),
          "message_created_by" => $this->get_message_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_messages by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_message_from_id_by_id method is stand for get the value ofmessage_from_id By
     * id.
     *
     * @var int message_from_id
     */
    public function get_message_from_id_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_message_from_id();
    }

    /**
     * get_message_to_id_by_id method is stand for get the value ofmessage_to_id By id.
     *
     * @var int message_to_id
     */
    public function get_message_to_id_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_message_to_id();
    }

    /**
     * get_message_subject_by_id method is stand for get the value ofmessage_subject By
     * id.
     *
     * @var varchar message_subject
     */
    public function get_message_subject_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_message_subject();
    }

    /**
     * get_message_content_by_id method is stand for get the value ofmessage_content By
     * id.
     *
     * @var text message_content
     */
    public function get_message_content_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_message_content();
    }

    /**
     * get_message_is_view_by_id method is stand for get the value ofmessage_is_view By
     * id.
     *
     * @var tinyint message_is_view
     */
    public function get_message_is_view_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_message_is_view();
    }

    /**
     * get_message_status_by_id method is stand for get the value ofmessage_status By
     * id.
     *
     * @var varchar message_status
     */
    public function get_message_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_message_status();
    }

    /**
     * get_message_updated_by_by_id method is stand for get the value
     * ofmessage_updated_by By id.
     *
     * @var int message_updated_by
     */
    public function get_message_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_message_updated_by();
    }

    /**
     * get_message_updated_date_by_id method is stand for get the value
     * ofmessage_updated_date By id.
     *
     * @var timestamp message_updated_date
     */
    public function get_message_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_message_updated_date()));
    }

    /**
     * get_message_created_by_by_id method is stand for get the value
     * ofmessage_created_by By id.
     *
     * @var int message_created_by
     */
    public function get_message_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_message_created_by();
    }

    /**
     * get_message_created_date_by_id method is stand for get the value
     * ofmessage_created_date By id.
     *
     * @var timestamp message_created_date
     */
    public function get_message_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_message_created_date()));
    }


}
