<?php

class Application_Model_MessageLogic extends Application_Model_Message
{

    public function getInboxMessage()
    {
        $obj_user = new Application_Model_UserLogic(-1);
        $columns = array('user_name', 'message_subject', 'message_created_date', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_MessageLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->from(array("l"=>$this->_name, "u"=>"asit_user"), 
                array("l.id", "u.user_name", 'l.message_subject', 'l.message_updated_date'));
        $where->joinLeft(array("u"=>"asit_user"),
                'l.message_from_id = u.id', array())
                ->setIntegrityCheck(false);
        $where->where('message_to_id = ?', $obj_user->getLoggedInUserId())->where('message_status = ?', 'Send');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            if(Application_Model_RolePermissionLogic::isPermitted("Message:View")) {
                $action = '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"message", "action"=>"index", "id"=>$row->id)).'"><input type="button" value="View" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Message:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"message", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->user_name, $row->message_subject, Application_Model_Util_Date::convertToDisplay($row->message_updated_date), $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getOutboxMessage()
    {
        $obj_user = new Application_Model_UserLogic(-1);
        $columns = array('user_name', 'message_subject', 'message_created_date', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_MessageLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->from(array("l"=>$this->_name, "u"=>"asit_user"), 
                array("l.id", "u.user_name", 'l.message_subject', 'l.message_updated_date'));
        $where->joinLeft(array("u"=>"asit_user"),
                'l.message_to_id = u.id', array())
                ->setIntegrityCheck(false);
        $where->where('message_from_id = ?', $obj_user->getLoggedInUserId())->where('message_status = ?', 'Send');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            if(Application_Model_RolePermissionLogic::isPermitted("Message:View")) {
                $action = '<a href="'.$url->url(array("controller"=>"message", "action"=>"index", "id"=>$row->id)).'"><input type="button" value="View" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Message:Delete")) {
                $action .= '<a href="'.$url->url(array("controller"=>"message", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->user_name, $row->message_subject, Application_Model_Util_Date::convertToDisplay($row->message_updated_date), $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getDraftMessage()
    {
        $obj_user = new Application_Model_UserLogic(-1);
        $columns = array('user_name', 'message_subject', 'message_created_date', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_MessageLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->from(array("l"=>$this->_name, "u"=>"asit_user"), 
                array("l.id", "u.user_name", 'l.message_subject', 'l.message_updated_date'));
        $where->joinLeft(array("u"=>"asit_user"),
                'l.message_to_id = u.id', array())
                ->setIntegrityCheck(false);
        $where->where('message_from_id = ?', $obj_user->getLoggedInUserId())->where('message_status = ?', 'Draft');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            if(Application_Model_RolePermissionLogic::isPermitted("Message:Edit")) {
                $action = '<a href="'.$url->url(array("controller"=>"message", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="edit" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Message:Delete")) {
                $action .= '<a href="'.$url->url(array("controller"=>"message", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->user_name, $row->message_subject, Application_Model_Util_Date::convertToDisplay($row->message_updated_date), $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function sendMessage($to, $subject, $message, $from = null) {
        $obj_user = new Application_Model_UserLogic(-1);
        $this->set_id(-1);
        $this->set_message_from_id(($from != null) ? $from : $obj_user->getLoggedInUserId());
        $this->set_message_to_id($to);
        $this->set_message_subject($subject);
        $this->set_message_content($message);
        $this->set_message_is_view(0);
        $this->set_message_status('Send');
        $this->set_message_updated_by($obj_user->getLoggedInUserId());
        $this->set_message_created_by($obj_user->getLoggedInUserId());
        $this->save();
    }

}

