<?php

class Application_Model_Nav extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_nav';

    private $_id = null;

    private $_nav_title = null;

    private $_nav_url = null;

    private $_nav_icon_class = null;

    private $_nav_permission = null;

    private $_nav_parent = null;

    private $_nav_order = null;

    private $_nav_status = null;

    private $_nav_updated_by = null;

    private $_nav_updated_date = null;

    private $_nav_created_by = null;

    private $_nav_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get nav_title method is stand for get the value of nav_title.
     *
     * @var varchar nav_title
     */
    public function get_nav_title()
    {
        return $this->_nav_title;
    }

    /**
     * set nav_title method is stand for set the value of nav_title.
     *
     * @var varchar nav_title
     */
    public function set_nav_title($value)
    {
        $this->_nav_title = $value;
    }

    /**
     * get nav_url method is stand for get the value of nav_url.
     *
     * @var varchar nav_url
     */
    public function get_nav_url()
    {
        return $this->_nav_url;
    }

    /**
     * set nav_url method is stand for set the value of nav_url.
     *
     * @var varchar nav_url
     */
    public function set_nav_url($value)
    {
        $this->_nav_url = $value;
    }

    /**
     * get nav_icon_class method is stand for get the value of nav_icon_class.
     *
     * @var varchar nav_icon_class
     */
    public function get_nav_icon_class()
    {
        return $this->_nav_icon_class;
    }

    /**
     * set nav_icon_class method is stand for set the value of nav_icon_class.
     *
     * @var varchar nav_icon_class
     */
    public function set_nav_icon_class($value)
    {
        $this->_nav_icon_class = $value;
    }

    /**
     * get nav_permission method is stand for get the value of nav_permission.
     *
     * @var varchar nav_permission
     */
    public function get_nav_permission()
    {
        return $this->_nav_permission;
    }

    /**
     * set nav_permission method is stand for set the value of nav_permission.
     *
     * @var varchar nav_permission
     */
    public function set_nav_permission($value)
    {
        $this->_nav_permission = $value;
    }

    /**
     * get nav_parent method is stand for get the value of nav_parent.
     *
     * @var int nav_parent
     */
    public function get_nav_parent()
    {
        return (int) $this->_nav_parent;
    }

    /**
     * set nav_parent method is stand for set the value of nav_parent.
     *
     * @var int nav_parent
     */
    public function set_nav_parent($value)
    {
        $this->_nav_parent = (int) $value;
    }

    /**
     * get nav_order method is stand for get the value of nav_order.
     *
     * @var int nav_order
     */
    public function get_nav_order()
    {
        return (int) $this->_nav_order;
    }

    /**
     * set nav_order method is stand for set the value of nav_order.
     *
     * @var int nav_order
     */
    public function set_nav_order($value)
    {
        $this->_nav_order = (int) $value;
    }

    /**
     * get nav_status method is stand for get the value of nav_status.
     *
     * @var varchar nav_status
     */
    public function get_nav_status()
    {
        return $this->_nav_status;
    }

    /**
     * set nav_status method is stand for set the value of nav_status.
     *
     * @var varchar nav_status
     */
    public function set_nav_status($value)
    {
        $this->_nav_status = $value;
    }

    /**
     * get nav_updated_by method is stand for get the value of nav_updated_by.
     *
     * @var int nav_updated_by
     */
    public function get_nav_updated_by()
    {
        return (int) $this->_nav_updated_by;
    }

    /**
     * set nav_updated_by method is stand for set the value of nav_updated_by.
     *
     * @var int nav_updated_by
     */
    public function set_nav_updated_by($value)
    {
        $this->_nav_updated_by = (int) $value;
    }

    /**
     * get nav_updated_date method is stand for get the value of nav_updated_date.
     *
     * @var timestamp nav_updated_date
     */
    public function get_nav_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_nav_updated_date));
    }

    /**
     * set nav_updated_date method is stand for set the value of nav_updated_date.
     *
     * @var timestamp nav_updated_date
     */
    public function set_nav_updated_date($value)
    {
        $this->_nav_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get nav_created_by method is stand for get the value of nav_created_by.
     *
     * @var int nav_created_by
     */
    public function get_nav_created_by()
    {
        return (int) $this->_nav_created_by;
    }

    /**
     * set nav_created_by method is stand for set the value of nav_created_by.
     *
     * @var int nav_created_by
     */
    public function set_nav_created_by($value)
    {
        $this->_nav_created_by = (int) $value;
    }

    /**
     * get nav_created_date method is stand for get the value of nav_created_date.
     *
     * @var timestamp nav_created_date
     */
    public function get_nav_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_nav_created_date));
    }

    /**
     * set nav_created_date method is stand for set the value of nav_created_date.
     *
     * @var timestamp nav_created_date
     */
    public function set_nav_created_date($value)
    {
        $this->_nav_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_nav by set id thru constructor.
     *
     * @var int id
     * @var varchar nav_title
     * @var varchar nav_url
     * @var varchar nav_icon_class
     * @var varchar nav_permission
     * @var int nav_parent
     * @var int nav_order
     * @var varchar nav_status
     * @var int nav_updated_by
     * @var timestamp nav_updated_date
     * @var int nav_created_by
     * @var timestamp nav_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_nav_title($row->nav_title);
          $this->set_nav_url($row->nav_url);
          $this->set_nav_icon_class($row->nav_icon_class);
          $this->set_nav_permission($row->nav_permission);
          $this->set_nav_parent($row->nav_parent);
          $this->set_nav_order($row->nav_order);
          $this->set_nav_status($row->nav_status);
          $this->set_nav_updated_by($row->nav_updated_by);
          $this->set_nav_updated_date($row->nav_updated_date);
          $this->set_nav_created_by($row->nav_created_by);
          $this->set_nav_created_date($row->nav_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar nav_title
     * @var varchar nav_url
     * @var varchar nav_icon_class
     * @var varchar nav_permission
     * @var int nav_parent
     * @var int nav_order
     * @var varchar nav_status
     * @var int nav_updated_by
     * @var int nav_created_by
     */
    public function save()
    {
        $data = array(
          "nav_title" => $this->get_nav_title(),
          "nav_url" => $this->get_nav_url(),
          "nav_icon_class" => $this->get_nav_icon_class(),
          "nav_permission" => $this->get_nav_permission(),
          "nav_parent" => $this->get_nav_parent(),
          "nav_order" => $this->get_nav_order(),
          "nav_status" => $this->get_nav_status(),
          "nav_updated_by" => $this->get_nav_updated_by(),
          "nav_created_by" => $this->get_nav_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_nav by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_nav_title_by_id method is stand for get the value ofnav_title By id.
     *
     * @var varchar nav_title
     */
    public function get_nav_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_nav_title();
    }

    /**
     * get_nav_url_by_id method is stand for get the value ofnav_url By id.
     *
     * @var varchar nav_url
     */
    public function get_nav_url_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_nav_url();
    }

    /**
     * get_nav_icon_class_by_id method is stand for get the value ofnav_icon_class By
     * id.
     *
     * @var varchar nav_icon_class
     */
    public function get_nav_icon_class_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_nav_icon_class();
    }

    /**
     * get_nav_permission_by_id method is stand for get the value ofnav_permission By
     * id.
     *
     * @var varchar nav_permission
     */
    public function get_nav_permission_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_nav_permission();
    }

    /**
     * get_nav_parent_by_id method is stand for get the value ofnav_parent By id.
     *
     * @var int nav_parent
     */
    public function get_nav_parent_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_nav_parent();
    }

    /**
     * get_nav_order_by_id method is stand for get the value ofnav_order By id.
     *
     * @var int nav_order
     */
    public function get_nav_order_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_nav_order();
    }

    /**
     * get_nav_status_by_id method is stand for get the value ofnav_status By id.
     *
     * @var varchar nav_status
     */
    public function get_nav_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_nav_status();
    }

    /**
     * get_nav_updated_by_by_id method is stand for get the value ofnav_updated_by By
     * id.
     *
     * @var int nav_updated_by
     */
    public function get_nav_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_nav_updated_by();
    }

    /**
     * get_nav_updated_date_by_id method is stand for get the value ofnav_updated_date
     * By id.
     *
     * @var timestamp nav_updated_date
     */
    public function get_nav_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_nav_updated_date()));
    }

    /**
     * get_nav_created_by_by_id method is stand for get the value ofnav_created_by By
     * id.
     *
     * @var int nav_created_by
     */
    public function get_nav_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_nav_created_by();
    }

    /**
     * get_nav_created_date_by_id method is stand for get the value ofnav_created_date
     * By id.
     *
     * @var timestamp nav_created_date
     */
    public function get_nav_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_nav_created_date()));
    }


}
