<?php

class Application_Model_News extends Zend_Db_Table_Abstract
{
    
    protected $_name = 'asit_news';
    
    private $_id = null;
    
    private $_news_title = null;
    
    private $_news_image = null;
    
    private $_news_short_desc = null;
    
    private $_news_desc = null;
    
    private $_news_url = null;
    
    private $_news_meta_key = null;
    
    private $_news_meta_desc = null;
    
    private $_news_status = null;
    
    private $_news_updated_by = null;
    
    private $_news_updated_date = null;
    
    private $_news_created_by = null;
    
    private $_news_created_date = null;
    
    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
            $this->fetch();
        }
    }
    
    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }
    
    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }
    
    /**
     * get news_title method is stand for get the value of news_title.
     *
     * @var varchar news_title
     */
    public function get_news_title()
    {
        return $this->_news_title;
    }
    
    /**
     * set news_title method is stand for set the value of news_title.
     *
     * @var varchar news_title
     */
    public function set_news_title($value)
    {
        $this->_news_title = $value;
    }
    
    /**
     * get news_image method is stand for get the value of news_image.
     *
     * @var varchar news_image
     */
    public function get_news_image()
    {
        return $this->_news_image;
    }
    
    /**
     * set news_image method is stand for set the value of news_image.
     *
     * @var varchar news_image
     */
    public function set_news_image($value)
    {
        $this->_news_image = $value;
    }
    
    /**
     * get news_short_desc method is stand for get the value of news_short_desc.
     *
     * @var varchar news_short_desc
     */
    public function get_news_short_desc()
    {
        return $this->_news_short_desc;
    }
    
    /**
     * set news_short_desc method is stand for set the value of news_short_desc.
     *
     * @var varchar news_short_desc
     */
    public function set_news_short_desc($value)
    {
        $this->_news_short_desc = $value;
    }
    
    /**
     * get news_desc method is stand for get the value of news_desc.
     *
     * @var text news_desc
     */
    public function get_news_desc()
    {
        return $this->_news_desc;
    }
    
    /**
     * set news_desc method is stand for set the value of news_desc.
     *
     * @var text news_desc
     */
    public function set_news_desc($value)
    {
        $this->_news_desc = $value;
    }
    
    /**
     * get news_url method is stand for get the value of news_url.
     *
     * @var varchar news_url
     */
    public function get_news_url()
    {
        return $this->_news_url;
    }
    
    /**
     * set news_url method is stand for set the value of news_url.
     *
     * @var varchar news_url
     */
    public function set_news_url($value)
    {
        $this->_news_url = $value;
    }
    
    /**
     * get news_meta_key method is stand for get the value of news_meta_key.
     *
     * @var varchar news_meta_key
     */
    public function get_news_meta_key()
    {
        return $this->_news_meta_key;
    }
    
    /**
     * set news_meta_key method is stand for set the value of news_meta_key.
     *
     * @var varchar news_meta_key
     */
    public function set_news_meta_key($value)
    {
        $this->_news_meta_key = $value;
    }
    
    /**
     * get news_meta_desc method is stand for get the value of news_meta_desc.
     *
     * @var varchar news_meta_desc
     */
    public function get_news_meta_desc()
    {
        return $this->_news_meta_desc;
    }
    
    /**
     * set news_meta_desc method is stand for set the value of news_meta_desc.
     *
     * @var varchar news_meta_desc
     */
    public function set_news_meta_desc($value)
    {
        $this->_news_meta_desc = $value;
    }
    
    /**
     * get news_status method is stand for get the value of news_status.
     *
     * @var varchar news_status
     */
    public function get_news_status()
    {
        return $this->_news_status;
    }
    
    /**
     * set news_status method is stand for set the value of news_status.
     *
     * @var varchar news_status
     */
    public function set_news_status($value)
    {
        $this->_news_status = $value;
    }
    
    /**
     * get news_updated_by method is stand for get the value of news_updated_by.
     *
     * @var int news_updated_by
     */
    public function get_news_updated_by()
    {
        return (int) $this->_news_updated_by;
    }
    
    /**
     * set news_updated_by method is stand for set the value of news_updated_by.
     *
     * @var int news_updated_by
     */
    public function set_news_updated_by($value)
    {
        $this->_news_updated_by = (int) $value;
    }
    
    /**
     * get news_updated_date method is stand for get the value of news_updated_date.
     *
     * @var timestamp news_updated_date
     */
    public function get_news_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_news_updated_date));
    }
    
    /**
     * set news_updated_date method is stand for set the value of news_updated_date.
     *
     * @var timestamp news_updated_date
     */
    public function set_news_updated_date($value)
    {
        $this->_news_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }
    
    /**
     * get news_created_by method is stand for get the value of news_created_by.
     *
     * @var int news_created_by
     */
    public function get_news_created_by()
    {
        return (int) $this->_news_created_by;
    }
    
    /**
     * set news_created_by method is stand for set the value of news_created_by.
     *
     * @var int news_created_by
     */
    public function set_news_created_by($value)
    {
        $this->_news_created_by = (int) $value;
    }
    
    /**
     * get news_created_date method is stand for get the value of news_created_date.
     *
     * @var timestamp news_created_date
     */
    public function get_news_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_news_created_date));
    }
    
    /**
     * set news_created_date method is stand for set the value of news_created_date.
     *
     * @var timestamp news_created_date
     */
    public function set_news_created_date($value)
    {
        $this->_news_created_date = date("Y-m-d H:i:s", strtotime($value));
    }
    
    /**
     * fetch data from asit_newss by set id thru constructor.
     *
     * @var int id
     * @var varchar news_title
     * @var varchar news_image
     * @var varchar news_short_desc
     * @var text news_desc
     * @var varchar news_url
     * @var varchar news_meta_key
     * @var varchar news_meta_desc
     * @var varchar news_status
     * @var int news_updated_by
     * @var timestamp news_updated_date
     * @var int news_created_by
     * @var timestamp news_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
            $this->set_id($row->id);
            $this->set_news_title($row->news_title);
            $this->set_news_image($row->news_image);
            $this->set_news_short_desc($row->news_short_desc);
            $this->set_news_desc($row->news_desc);
            $this->set_news_url($row->news_url);
            $this->set_news_meta_key($row->news_meta_key);
            $this->set_news_meta_desc($row->news_meta_desc);
            $this->set_news_status($row->news_status);
            $this->set_news_updated_by($row->news_updated_by);
            $this->set_news_updated_date($row->news_updated_date);
            $this->set_news_created_by($row->news_created_by);
            $this->set_news_created_date($row->news_created_date);
        }
    }
    
    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar news_title
     * @var varchar news_image
     * @var varchar news_short_desc
     * @var text news_desc
     * @var varchar news_url
     * @var varchar news_meta_key
     * @var varchar news_meta_desc
     * @var varchar news_status
     * @var int news_updated_by
     * @var int news_created_by
     */
    public function save()
    {
        $data = array(
            "news_title" => $this->get_news_title(),
            "news_image" => $this->get_news_image(),
            "news_short_desc" => $this->get_news_short_desc(),
            "news_desc" => $this->get_news_desc(),
            "news_url" => $this->get_news_url(),
            "news_meta_key" => $this->get_news_meta_key(),
            "news_meta_desc" => $this->get_news_meta_desc(),
            "news_status" => $this->get_news_status(),
            "news_updated_by" => $this->get_news_updated_by(),
            "news_created_by" => $this->get_news_created_by());
        if($this->get_id()==-1)
        {
            return $this->insert($data);
        }
        else
        {
            $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
            $this->update($data, $where);
        }
    }
    
    /**
     * remove method delete the record from asit_newss by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }
    
    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }
    
    /**
     * get_news_title_by_id method is stand for get the value ofnews_title By id.
     *
     * @var varchar news_title
     */
    public function get_news_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_news_title();
    }
    
    /**
     * get_news_image_by_id method is stand for get the value ofnews_image By id.
     *
     * @var varchar news_image
     */
    public function get_news_image_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_news_image();
    }
    
    /**
     * get_news_short_desc_by_id method is stand for get the value ofnews_short_desc By
     * id.
     *
     * @var varchar news_short_desc
     */
    public function get_news_short_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_news_short_desc();
    }
    
    /**
     * get_news_desc_by_id method is stand for get the value ofnews_desc By id.
     *
     * @var text news_desc
     */
    public function get_news_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_news_desc();
    }
    
    /**
     * get_news_url_by_id method is stand for get the value ofnews_url By id.
     *
     * @var varchar news_url
     */
    public function get_news_url_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_news_url();
    }
    
    /**
     * get_news_meta_key_by_id method is stand for get the value ofnews_meta_key By id.
     *
     * @var varchar news_meta_key
     */
    public function get_news_meta_key_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_news_meta_key();
    }
    
    /**
     * get_news_meta_desc_by_id method is stand for get the value ofnews_meta_desc By
     * id.
     *
     * @var varchar news_meta_desc
     */
    public function get_news_meta_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_news_meta_desc();
    }
    
    /**
     * get_news_status_by_id method is stand for get the value ofnews_status By id.
     *
     * @var varchar news_status
     */
    public function get_news_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_news_status();
    }
    
    /**
     * get_news_updated_by_by_id method is stand for get the value ofnews_updated_by By
     * id.
     *
     * @var int news_updated_by
     */
    public function get_news_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_news_updated_by();
    }
    
    /**
     * get_news_updated_date_by_id method is stand for get the value
     * ofnews_updated_date By id.
     *
     * @var timestamp news_updated_date
     */
    public function get_news_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_news_updated_date()));
    }
    
    /**
     * get_news_created_by_by_id method is stand for get the value ofnews_created_by By
     * id.
     *
     * @var int news_created_by
     */
    public function get_news_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_news_created_by();
    }
    
    /**
     * get_news_created_date_by_id method is stand for get the value
     * ofnews_created_date By id.
     *
     * @var timestamp news_created_date
     */
    public function get_news_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_news_created_date()));
    }
    
    
}
