<?php

class Application_Model_NewsLogic extends Application_Model_News
{
    public function fetchDataTableSelect()
    {
        $columns = array('news_title', 'news_short_desc', 'news_url', 'news_status', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_NewsLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('news_status != ?', 'D');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("News:Edit")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"news", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("News:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"news", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->news_title, $row->news_short_desc, $row->news_url, ($row->news_status == 'A') ? 'Active' : ($row->news_status == 'E') ? 'Draft' : 'Block', $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getActiveNews($limit = null) {
        return $this->fetchAll($this->getActiveNewsSelect($limit));
    }
    
    public function getActiveNewsSelect($limit = null) {
        $where = $this->select()->where('news_status = ?', 'A')->order('id desc');
        if(null != $limit) {
            $where->limit($limit);
        }
        return $where;
    }
    
    public function countNewsUrl($url) {
        $where = $this->select()->where('news_status = ?', 'A')->where('news_url = ?', $url);
        return count($this->fetchAll($where));
    }
    
    public function generateNewsUrl($url) {
        $url = strtolower(preg_replace('/[^a-zA-Z0-9]/', '-', $url));
        $existRecord = $this->countNewsUrl($url);
        if($existRecord > 0) {
            return $url.'-'.$existRecord;
        }else {
            return $url;
        }
    }
    
    public function getNewsByUrl($url) {
        $where = $this->select()->where('news_url = ?', $url)->where('news_status = ?', 'A');
        $row = $this->fetchRow($where);
        $this->set_id($row['id']);
        $this->fetch();
    }
}

