<?php

class Application_Model_Page extends Zend_Db_Table_Abstract
{
    
    protected $_name = 'asit_pages';
    
    private $_id = null;
    
    private $_page_title = null;
    
    private $_page_image = null;
    
    private $_page_short_desc = null;
    
    private $_page_desc = null;
    
    private $_page_url = null;
    
    private $_page_meta_key = null;
    
    private $_page_meta_desc = null;
    
    private $_page_status = null;
    
    private $_page_updated_by = null;
    
    private $_page_updated_date = null;
    
    private $_page_created_by = null;
    
    private $_page_created_date = null;
    
    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
            $this->fetch();
        }
    }
    
    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }
    
    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }
    
    /**
     * get page_title method is stand for get the value of page_title.
     *
     * @var varchar page_title
     */
    public function get_page_title()
    {
        return $this->_page_title;
    }
    
    /**
     * set page_title method is stand for set the value of page_title.
     *
     * @var varchar page_title
     */
    public function set_page_title($value)
    {
        $this->_page_title = $value;
    }
    
    /**
     * get page_image method is stand for get the value of page_image.
     *
     * @var varchar page_image
     */
    public function get_page_image()
    {
        return $this->_page_image;
    }
    
    /**
     * set page_image method is stand for set the value of page_image.
     *
     * @var varchar page_image
     */
    public function set_page_image($value)
    {
        $this->_page_image = $value;
    }
    
    /**
     * get page_short_desc method is stand for get the value of page_short_desc.
     *
     * @var varchar page_short_desc
     */
    public function get_page_short_desc()
    {
        return $this->_page_short_desc;
    }
    
    /**
     * set page_short_desc method is stand for set the value of page_short_desc.
     *
     * @var varchar page_short_desc
     */
    public function set_page_short_desc($value)
    {
        $this->_page_short_desc = $value;
    }
    
    /**
     * get page_desc method is stand for get the value of page_desc.
     *
     * @var text page_desc
     */
    public function get_page_desc()
    {
        return $this->_page_desc;
    }
    
    /**
     * set page_desc method is stand for set the value of page_desc.
     *
     * @var text page_desc
     */
    public function set_page_desc($value)
    {
        $this->_page_desc = $value;
    }
    
    /**
     * get page_url method is stand for get the value of page_url.
     *
     * @var varchar page_url
     */
    public function get_page_url()
    {
        return $this->_page_url;
    }
    
    /**
     * set page_url method is stand for set the value of page_url.
     *
     * @var varchar page_url
     */
    public function set_page_url($value)
    {
        $this->_page_url = $value;
    }
    
    /**
     * get page_meta_key method is stand for get the value of page_meta_key.
     *
     * @var varchar page_meta_key
     */
    public function get_page_meta_key()
    {
        return $this->_page_meta_key;
    }
    
    /**
     * set page_meta_key method is stand for set the value of page_meta_key.
     *
     * @var varchar page_meta_key
     */
    public function set_page_meta_key($value)
    {
        $this->_page_meta_key = $value;
    }
    
    /**
     * get page_meta_desc method is stand for get the value of page_meta_desc.
     *
     * @var varchar page_meta_desc
     */
    public function get_page_meta_desc()
    {
        return $this->_page_meta_desc;
    }
    
    /**
     * set page_meta_desc method is stand for set the value of page_meta_desc.
     *
     * @var varchar page_meta_desc
     */
    public function set_page_meta_desc($value)
    {
        $this->_page_meta_desc = $value;
    }
    
    /**
     * get page_status method is stand for get the value of page_status.
     *
     * @var varchar page_status
     */
    public function get_page_status()
    {
        return $this->_page_status;
    }
    
    /**
     * set page_status method is stand for set the value of page_status.
     *
     * @var varchar page_status
     */
    public function set_page_status($value)
    {
        $this->_page_status = $value;
    }
    
    /**
     * get page_updated_by method is stand for get the value of page_updated_by.
     *
     * @var int page_updated_by
     */
    public function get_page_updated_by()
    {
        return (int) $this->_page_updated_by;
    }
    
    /**
     * set page_updated_by method is stand for set the value of page_updated_by.
     *
     * @var int page_updated_by
     */
    public function set_page_updated_by($value)
    {
        $this->_page_updated_by = (int) $value;
    }
    
    /**
     * get page_updated_date method is stand for get the value of page_updated_date.
     *
     * @var timestamp page_updated_date
     */
    public function get_page_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_page_updated_date));
    }
    
    /**
     * set page_updated_date method is stand for set the value of page_updated_date.
     *
     * @var timestamp page_updated_date
     */
    public function set_page_updated_date($value)
    {
        $this->_page_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }
    
    /**
     * get page_created_by method is stand for get the value of page_created_by.
     *
     * @var int page_created_by
     */
    public function get_page_created_by()
    {
        return (int) $this->_page_created_by;
    }
    
    /**
     * set page_created_by method is stand for set the value of page_created_by.
     *
     * @var int page_created_by
     */
    public function set_page_created_by($value)
    {
        $this->_page_created_by = (int) $value;
    }
    
    /**
     * get page_created_date method is stand for get the value of page_created_date.
     *
     * @var timestamp page_created_date
     */
    public function get_page_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_page_created_date));
    }
    
    /**
     * set page_created_date method is stand for set the value of page_created_date.
     *
     * @var timestamp page_created_date
     */
    public function set_page_created_date($value)
    {
        $this->_page_created_date = date("Y-m-d H:i:s", strtotime($value));
    }
    
    /**
     * fetch data from asit_pages by set id thru constructor.
     *
     * @var int id
     * @var varchar page_title
     * @var varchar page_image
     * @var varchar page_short_desc
     * @var text page_desc
     * @var varchar page_url
     * @var varchar page_meta_key
     * @var varchar page_meta_desc
     * @var varchar page_status
     * @var int page_updated_by
     * @var timestamp page_updated_date
     * @var int page_created_by
     * @var timestamp page_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
            $this->set_id($row->id);
            $this->set_page_title($row->page_title);
            $this->set_page_image($row->page_image);
            $this->set_page_short_desc($row->page_short_desc);
            $this->set_page_desc($row->page_desc);
            $this->set_page_url($row->page_url);
            $this->set_page_meta_key($row->page_meta_key);
            $this->set_page_meta_desc($row->page_meta_desc);
            $this->set_page_status($row->page_status);
            $this->set_page_updated_by($row->page_updated_by);
            $this->set_page_updated_date($row->page_updated_date);
            $this->set_page_created_by($row->page_created_by);
            $this->set_page_created_date($row->page_created_date);
        }
    }
    
    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar page_title
     * @var varchar page_image
     * @var varchar page_short_desc
     * @var text page_desc
     * @var varchar page_url
     * @var varchar page_meta_key
     * @var varchar page_meta_desc
     * @var varchar page_status
     * @var int page_updated_by
     * @var int page_created_by
     */
    public function save()
    {
        $data = array(
            "page_title" => $this->get_page_title(),
            "page_image" => $this->get_page_image(),
            "page_short_desc" => $this->get_page_short_desc(),
            "page_desc" => $this->get_page_desc(),
            "page_url" => $this->get_page_url(),
            "page_meta_key" => $this->get_page_meta_key(),
            "page_meta_desc" => $this->get_page_meta_desc(),
            "page_status" => $this->get_page_status(),
            "page_updated_by" => $this->get_page_updated_by(),
            "page_created_by" => $this->get_page_created_by());
        if($this->get_id()==-1)
        {
            return $this->insert($data);
        }
        else
        {
            $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
            $this->update($data, $where);
        }
    }
    
    /**
     * remove method delete the record from asit_pages by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }
    
    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }
    
    /**
     * get_page_title_by_id method is stand for get the value ofpage_title By id.
     *
     * @var varchar page_title
     */
    public function get_page_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_page_title();
    }
    
    /**
     * get_page_image_by_id method is stand for get the value ofpage_image By id.
     *
     * @var varchar page_image
     */
    public function get_page_image_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_page_image();
    }
    
    /**
     * get_page_short_desc_by_id method is stand for get the value ofpage_short_desc By
     * id.
     *
     * @var varchar page_short_desc
     */
    public function get_page_short_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_page_short_desc();
    }
    
    /**
     * get_page_desc_by_id method is stand for get the value ofpage_desc By id.
     *
     * @var text page_desc
     */
    public function get_page_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_page_desc();
    }
    
    /**
     * get_page_url_by_id method is stand for get the value ofpage_url By id.
     *
     * @var varchar page_url
     */
    public function get_page_url_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_page_url();
    }
    
    /**
     * get_page_meta_key_by_id method is stand for get the value ofpage_meta_key By id.
     *
     * @var varchar page_meta_key
     */
    public function get_page_meta_key_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_page_meta_key();
    }
    
    /**
     * get_page_meta_desc_by_id method is stand for get the value ofpage_meta_desc By
     * id.
     *
     * @var varchar page_meta_desc
     */
    public function get_page_meta_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_page_meta_desc();
    }
    
    /**
     * get_page_status_by_id method is stand for get the value ofpage_status By id.
     *
     * @var varchar page_status
     */
    public function get_page_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_page_status();
    }
    
    /**
     * get_page_updated_by_by_id method is stand for get the value ofpage_updated_by By
     * id.
     *
     * @var int page_updated_by
     */
    public function get_page_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_page_updated_by();
    }
    
    /**
     * get_page_updated_date_by_id method is stand for get the value
     * ofpage_updated_date By id.
     *
     * @var timestamp page_updated_date
     */
    public function get_page_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_page_updated_date()));
    }
    
    /**
     * get_page_created_by_by_id method is stand for get the value ofpage_created_by By
     * id.
     *
     * @var int page_created_by
     */
    public function get_page_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_page_created_by();
    }
    
    /**
     * get_page_created_date_by_id method is stand for get the value
     * ofpage_created_date By id.
     *
     * @var timestamp page_created_date
     */
    public function get_page_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_page_created_date()));
    }
    
    
}
