<?php

class Application_Model_PageLogic extends Application_Model_Page
{
    public function fetchDataTableSelect()
    {
        $columns = array('page_title', 'page_short_desc', 'page_url', 'page_status', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_PageLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('page_status != ?', 'D');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Page:Edit")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"page", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Page:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"page", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->page_title, $row->page_short_desc, $row->page_url, ($row->page_status == 'A') ? 'Active' : ($row->page_status == 'E') ? 'Draft' : 'Block', $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getActivePages() {
        $where = $this->select()->where('page_status = ?', 'A')->order('page_title');
        return $this->fetchAll($where);
    }
    
    public function countPageUrl($url) {
        $where = $this->select()->where('page_status = ?', 'A')->where('page_url = ?', $url);
        return count($this->fetchAll($where));
    }
    
    public function generatePageUrl($url) {
        $url = strtolower(preg_replace('/[^a-zA-Z0-9]/', '-', $url));
        $existRecord = $this->countPageUrl($url);
        if($existRecord > 0) {
            return $url.'-'.$existRecord;
        }else {
            return $url;
        }
    }
    
    public function getPageByUrl($url) {
        $where = $this->select()->where('page_url = ?', $url)->where('page_status = ?', 'A');
        $row = $this->fetchRow($where);
        $this->set_id($row['id']);
        $this->fetch();
    }
}

